<?php

namespace App\Http\Responses\Focus\productprocessing;

use App\Models\productcategory\Productcategory;
use App\Models\productvariable\Productvariable;
use App\Models\warehouse\Warehouse;
use Illuminate\Contracts\Support\Responsable;
use App\Models\product\Product;

class CreateResponse implements Responsable
{
    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $product_categories = Productcategory::all();
        $warehouses = Warehouse::all();
        $productvariables = Productvariable::all();
        $products = Product::all();

        return view('focus.productcombinations.processed.create')->with(compact('product_categories','products', 'productvariables', 'warehouses'));
    }
}
