<?php

namespace App\Http\Responses\Focus\productcombination;

use Illuminate\Contracts\Support\Responsable;
use App\Models\product\Product;
use App\Models\productcategory\Productcategory;
use App\Models\productvariable\Productvariable;
use App\Models\warehouse\Warehouse;


class CreateResponse implements Responsable
{
    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $ins = auth()->user()->ins;
        $products = Product::orderBy('name', 'ASC')->get();
        $product_categories = Productcategory::all();
        $productvariables = Productvariable::all();
        $warehouses = Warehouse::all();

        return view('focus.productcombinations.create', compact('products', 'product_categories','productvariables','warehouses'));
    }
}
