<?php

namespace App\Http\Responses\Focus\print_design;

use Illuminate\Contracts\Support\Responsable;
use App\Models\customer\Customer;

class EditResponse implements Responsable
{
    /**
     * @var App\Models\print_design\PrintDesign
     */
    protected $print_designs;

    /**
     * @param App\Models\print_design\print_design $print_designs
     */
    public function __construct($print_designs)
    {
        $this->print_designs = $print_designs;
    }

    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $customers = Customer::all(['id', 'company']);
        return view('focus.print_designs.edit')->with([
            'print_designs' => $this->print_designs,
            'customers' => $customers
        ]);
    }
}