<?php

namespace App\Http\Responses\Focus\paper_width;

use Illuminate\Contracts\Support\Responsable;
use App\Models\productvariable\Productvariable;
use App\Models\paper\PaperName;


class EditResponse implements Responsable
{
    /**
     * @var App\Models\paper_width\paper_width
     */
    protected $paper_widths;

    /**
     * @param App\Models\paper_width\paper_width $paper_widths
     */
    public function __construct($paper_widths)
    {
        $this->paper_widths = $paper_widths;
    }

    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $productvariables = Productvariable::all();
        $paper_name = PaperName::all(['id','name']);
        return view('focus.paper_widths.edit')->with([
            'paper_width' => $this->paper_widths,
            'productvariables' => $productvariables,
            'paper_name' => $paper_name
        ]);
    }
}