<?php

namespace App\Http\Responses\Focus\jobcard;

use Illuminate\Contracts\Support\Responsable;
use App\Models\customer\Customer;
use App\Models\process\Process;
use App\Models\print_design\PrintDesign;
use Carbon\Carbon;
use App\Models\jobcard\JobCard;

class EditResponse implements Responsable
{
    /**
     * @var App\Models\jobcard\jobcard
     */
    protected $jobcards;

    /**
     * @param App\Models\jobcard\jobcard $jobcards
     */
    public function __construct($jobcards)
    {
        $this->jobcards = $jobcards;
    }

    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $customers = Customer::all(['id', 'company']);
        $processes = Process::all(['id', 'process_name']);
        $this->jobcards->flute = explode(', ', $this->jobcards->flute);
        $designs = PrintDesign::where('status','active')->get(['id','description']);
        // dd($flute);
         if (request('task') == 'jobcard_to_jobcard') {
            // $words['title'] = 'Copy Quote to Jobcard';
            $currentDate = Carbon::now()->format('Ym');
            $current_month = substr($currentDate, 4);
            $current_year = substr($currentDate, 0, 4);
            $start_month = Carbon::now()->startOfMonth();
            $end_month = Carbon::now()->endOfMonth();
            $count = JobCard::whereBetween('created_at',[$start_month, $end_month])->count();
            $count += 1;
            $jobcard_number = gen4tid('',$count).''.$current_month.''.$current_year;
            

            return view('focus.jobcards.edit')
                ->with([
                    'jobcards' => $this->jobcards,
                    'customers' => $customers,
                    'processes' => $processes,
                    'designs' => $designs,
                    'jobcard_number' => $jobcard_number
                ]);
        }
        return view('focus.jobcards.edit')->with([
            'jobcards' => $this->jobcards,
            'customers' => $customers,
            'processes' => $processes,
            'designs' => $designs
        ]);
    }
}