<?php

namespace App\Http\Responses\Focus\customer;

use App\Models\account\Account;
use App\Models\additional\Additional;
use App\Models\currency\Currency;
use App\Models\customergroup\Customergroup;
use Illuminate\Contracts\Support\Responsable;

class EditResponse implements Responsable
{
    /**
     * @var App\Models\customer\Customer
     */
    protected $customer;

    /**
     * @param App\Models\customer\Customer $customer
     */
    public function __construct($customer)
    {
        $this->customer = $customer;
    }

    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $customergroups = Customergroup::all();
        $account = Account::where('system', 'receivable')->first();
        $currencies = Currency::get();

        return view('focus.customers.edit', compact('customergroups', 'account', 'currencies'))->with(['customer' => $this->customer]);
            
    }
}
