<?php

namespace App\Http\Responses\Focus\bom;

use Illuminate\Contracts\Support\Responsable;
use App\Models\product\Product;
use App\Models\car_model\CarModel;
use App\Models\productvariable\Productvariable;
use App\Models\shops\Shop;
use App\Models\jobcard\JobCard;

class EditResponse implements Responsable
{

    protected $bom;

    public function __construct($bom)
    {
        $this->bom = $bom;
    }

    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $products = Product::all();
        $shops = Shop::all();
        $car_models = CarModel::all();
        $productvariables = Productvariable::all();
        $jobcards = JobCard::where('status','approved')->get();
        if (request('task') == 'bom_to_bom') {
            
            

            return view('focus.bom.edit', compact('products', 'shops', 'car_models','productvariables','jobcards'))
                ->with([
                    'bom' => $this->bom
                ]);
        }

        return view('focus.bom.edit',compact('products', 'shops', 'car_models','productvariables','jobcards'))->with([
            'bom' => $this->bom
        ]);
    }
}
