<?php

namespace App\Http\Responses\Focus\banktransfer;

use App\Models\account\Account;
use Illuminate\Contracts\Support\Responsable;

class EditResponse implements Responsable
{
    /**
     * @var App\Models\productcategory\Productcategory
     */
    protected $banktransfer;

    /**
     * @param App\Models\productcategory\Productcategory $productcategories
     */
    public function __construct($banktransfer)
    {
        $this->banktransfer = $banktransfer;
    }

    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $accounts = Account::whereHas('account_type', fn($q) => $q->where('code', 'bank'))->get();
        
        return view('focus.banktransfers.edit', compact('accounts'))->with([ 'banktransfer' => $this->banktransfer]);
    }
}
