<?php

namespace App\Http\Responses\Focus\assembly\material_issuing;

use Illuminate\Contracts\Support\Responsable;
use App\Models\productcategory\Productcategory;
use App\Models\productvariable\Productvariable;
use App\Models\warehouse\Warehouse;
use App\Models\product\Product;
use App\Models\assembly\assembly_station\AssemblyStation;
use App\Models\assembly\material_issuing\MaterialIssuing;

class CreateResponse implements Responsable
{
    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $product_categories = Productcategory::all();
        $warehouses = Warehouse::all();
        $productvariables = Productvariable::all();
        $products = Product::all();
        $assembly_stations = AssemblyStation::all();
        $material_issues = MaterialIssuing::count();
        return view('focus.assembly.material_issuing.create')->with(compact('material_issues','product_categories', 'assembly_stations','productvariables','products', 'warehouses'));
    }
}
