<?php

namespace App\Http\Responses\Focus\assembly\assembled_products;

use App\Models\product\Product;
use Illuminate\Contracts\Support\Responsable;
use App\Models\productvariable\Productvariable;
use App\Models\assembly\assembled_product\AssembledProduct;

class EditResponse implements Responsable
{
    protected $assembled_product;

    public function __construct($assembled_product)
    {
        $this->assembled_product = $assembled_product;
    }

    public function toResponse($request)
    {
        $products = Product::where('product_type', '!=', 'single')->get();
        $productvariables = Productvariable::all();
        $assembled_products = AssembledProduct::count();
        return view('focus.assembly.assembled_product.edit', compact('products', 'productvariables','assembled_products'))->with([
            'assembled_product' => $this->assembled_product
        ]);
    }
}
