<?php

namespace App\Http\Responses\Focus\assembly\assembled_products;

use App\Models\product\Product;
use Illuminate\Contracts\Support\Responsable;
use App\Models\productvariable\Productvariable;
use App\Models\assembly\assembled_product\AssembledProduct;

class CreateResponse implements Responsable
{
    /**
     * To Response
     *
     * @param \App\Http\Requests\Request $request
     *
     * @return \Illuminate\Contracts\View\Factory|\Illuminate\View\View
     */
    public function toResponse($request)
    {
        $products = Product::where('product_type', '!=', 'single')->get();
        $productvariables = Productvariable::all();
        $assembled_products = AssembledProduct::count();
        return view('focus.assembly.assembled_product.create', compact('products', 'productvariables','assembled_products'));
    }
}
