<?php

namespace App\Http\Controllers\Focus\stock_adjustment;

use App\Http\Controllers\Controller;
use App\Http\Requests\Focus\stock_adjustment\CreateStockAdjustmentRequest;
use App\Http\Requests\Focus\stock_adjustment\ManageStockAdjustmentRequest;
use App\Http\Requests\Focus\stock_adjustment\StoreStockAdjustmentRequest;
use Illuminate\Http\Request;
use App\Repositories\Focus\stock_adjustment\StockAdjustmentRepository;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\stock_adjustment\CreateResponse;
use App\Http\Responses\Focus\stock_adjustment\EditResponse;
use App\Models\product\Product;
use App\Models\product_bin\ProductBin;
use App\Models\stock_adjustment\StockAdjustment;

class StockAdjustmentController extends Controller
{

    protected $repository;

    public function __construct(StockAdjustmentRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(ManageStockAdjustmentRequest $request)
    {
        return new ViewResponse('focus.stock_adjustment.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(CreateStockAdjustmentRequest $request)
    {
        return new CreateResponse('focus.stock_adjustment.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreStockAdjustmentRequest $request)
    {
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;
        $input['user_id'] = auth()->user()->id;

        try {
            $this->repository->create($input);
        } catch (\Throwable $th) {
            dd($th);
            return errorHandler('Error making stock adjustment', $th);
        }

        return new RedirectResponse(route('biller.stock-adjustment.index'), ['flash_success' => 'Stock adjustment made successfully.']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $stockAdjustment = StockAdjustment::where('id',$id)->first();
        return new ViewResponse('focus.stock_adjustment.view', compact('stockAdjustment'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $stockAdjustment = StockAdjustment::where('id',$id)->first();
        return new EditResponse($stockAdjustment);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $stockAdjustment = StockAdjustment::where('id',$id)->first();
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;
        $input['user_id'] = auth()->user()->id;

        try {
            $this->repository->update($stockAdjustment, $input);
        } catch (\Throwable $th) {
            // dd($th);
            return errorHandler('Error updating stock adjustment', $th);
        }
        return new RedirectResponse(route('biller.stock-adjustment.index'), ['flash_success' => 'Stock Adjustment updated successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function approve($id){
        $stockAdjustment = StockAdjustment::where('id',$id)->first();

        foreach($stockAdjustment->items as $v){
            // Product::where('id', $v->product_id)->update([
            //     'qty' => $v->new_qty,
            // ]);
            $product = Product::find($v->product_id);
            if($product->paper_id > 0){
                $product->weight = $v->new_qty;
                $product->update();
            }else{
                $product->qty = $v->new_qty;
                $product->update();
            }
                // $product = Product::where('id', $v->product_id)->first();
                
                if($product->unit_id == null){
                    $unit = 0;
                }else{
                    $unit = $product->unit_id;
                }
    
                if($product->purchase_price == null){
                    $value = 0;
                }else{
                    $value = $product->purchase_price;
                }
    
                if($product->alert == null){
                    $alert = 0;
                }else{
                    $alert = $product->alert;
                }
    
                ProductBin::create([
    
                    'product_id' => $v->product_id,
                    'ref_no' => $id,
                    // 'supplier' => ,
                    'type' => 'stock-adjustment',
                    // 'unit' => $item['uom'],
                    'unit' => $unit,
                    'value' => $value,
                    'total_value' => $v->new_qty * $value,
                    'min_stock' => $alert,
                    'in' => $v->new_qty,
                    'out' => 0,
                    'balance' => $v->new_qty,
                    'user_id' => auth()->user()->id,
                    'ins' => auth()->user()->ins,
                ]);
        }
        $stockAdjustment->update([
            'status' => 1
        ]);

        return redirect()->back()->with(['flash_success' => 'Stock Adjustment has been approved successfully.']);
    }
}
