<?php

namespace App\Http\Controllers\Focus\shops;

use App\Http\Controllers\Controller;
use App\Models\shops\Shop;
use App\Repositories\Focus\shop\ShopRepository;
use Yajra\DataTables\Facades\DataTables;

class ShopTableController extends Controller
{
    const MODEL = Shop::class;

    protected $shop;

    public function __construct(ShopRepository $shop)
    {
        $this->shop = $shop;
    }

    public function __invoke()
    {
        $core = $this->shop->getForDataTable();

        // aggregate
        $shops = Shop::count();
        $aggregate = compact('shops');

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('name', function ($shop) {
                return $shop->name;
            })
            ->addColumn('code', function ($shop) {
                return $shop->code;
            })
            ->addColumn('created_at', function ($shop) {
                return  $shop->created_at->toDateString();
            })
            ->addColumn('actions', function ($shop) {
                return $shop->action_buttons;
            })
            ->addColumn('aggregate', function () use($aggregate) {
                return $aggregate;
            })
            ->make(true);
    }
}
