<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\request_quotation;

use App\Models\request_quotation\RequestQuotation;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\request_quotation\CreateResponse;
use App\Http\Responses\Focus\request_quotation\EditResponse;
use App\Repositories\Focus\request_quotation\RequestQuotationRepository;
use App\Models\supplier\Supplier;
use App\Models\Company\Company;
use Barryvdh\DomPDF\Facade\Pdf;

/**
 * request_quotationsController
 */
class RequestQuotationsController extends Controller
{
    /**
     * variable to store the repository object
     * @var RequestQuotationRepository
     */
    protected $repository;

    /**
     * contructor to initialize repository object
     * @param RequestQuotationRepository $repository ;
     */
    public function __construct(RequestQuotationRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     *
     * @param App\Http\Requests\Focus\request_quotation\Request $request
     * @return \App\Http\Responses\ViewResponse
     */
    public function index(Request $request)
    {
        return new ViewResponse('focus.request_quotations.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Createrequest_quotationRequestNamespace $request
     * @return \App\Http\Responses\Focus\request_quotation\CreateResponse
     */
    public function create(Request $request)
    {
        return new CreateResponse('focus.request_quotations.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param RequestNamespace $request
     * @return \App\Http\Responses\RedirectResponse
     */
    public function store(Request $request)
    {
        // dd($request->all());
        $data = $request->only([
            'note','date','due_date','term_id','tid'
        ]);
        $data_items = $request->only([
            'product','item_id','uom','product_quantity','product_type','num'
        ]);
        $process_items = $request->only([
            'supplier_id'
        ]);
        $data['ins'] = auth()->user()->ins;
        $data['user_id'] = auth()->user()->id;

        $data_items = modify_array($data_items);
        $process_items = modify_array($process_items);
        try {
            //Create the model using repository create method
            $this->repository->create(compact('data','data_items','process_items'));
        } catch (\Throwable $th) {
            return errorHandler('Error Creating request_quotations', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.request_quotations.index'), ['flash_success' => 'RFQ Created Successfully']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param App\Models\request_quotation\request_quotation $request_quotation
     * @param Editrequest_quotationRequestNamespace $request
     * @return \App\Http\Responses\Focus\request_quotation\EditResponse
     */
    public function edit(RequestQuotation $request_quotation, Request $request)
    {
        return new EditResponse($request_quotation);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Updaterequest_quotationRequestNamespace $request
     * @param App\Models\request_quotation\request_quotation $request_quotation
     * @return \App\Http\Responses\RedirectResponse
     */
    public function update(Request $request, RequestQuotation $request_quotation)
    {
        // dd($request->all());
        $data = $request->only([
            'note','date','due_date','term_id','tid'
        ]);
        $data_items = $request->only([
            'product','item_id','uom','product_quantity','product_type','num','id'
        ]);
        $process_items = $request->only([
            'supplier_id'
        ]);
        $data['ins'] = auth()->user()->ins;
        $data['user_id'] = auth()->user()->id;

        $data_items = modify_array($data_items);
        $process_items = modify_array($process_items);
        try {
            //Update the model using repository update method
            $this->repository->update($request_quotation, compact('data','data_items','process_items'));
        } catch (\Throwable $th) {
            return errorHandler('Error Updating request_quotations', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.request_quotations.index'), ['flash_success' => 'RFQ Updated Successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param Deleterequest_quotationRequestNamespace $request
     * @param App\Models\request_quotation\request_quotation $request_quotation
     * @return \App\Http\Responses\RedirectResponse
     */
    public function destroy(RequestQuotation $request_quotation, Request $request)
    {
        try {
            //Calling the delete method on repository
            $this->repository->delete($request_quotation);
        } catch (\Throwable $th) {
            return errorHandler('Error Deleting request_quotations', $th);
        }
        //returning with successfull message
        return new RedirectResponse(route('biller.request_quotations.index'), ['flash_success' => 'RFQ Deleted Successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param Deleterequest_quotationRequestNamespace $request
     * @param App\Models\request_quotation\request_quotation $request_quotation
     * @return \App\Http\Responses\RedirectResponse
     */
    public function show(RequestQuotation $request_quotation, Request $request)
    {

        //returning with successfull message
        return new ViewResponse('focus.request_quotations.view', compact('request_quotation'));
    }

    public function print_request_quotation(Request $request)
    {
        // dd($request->all());
        $resource = RequestQuotation::find($request->id);
        $supplier = Supplier::find($request->supplier_id);
        $company = Company::find($resource->ins);
        $pdfContent = Pdf::loadView('focus.bill.print_request_quotation', [
            'resource' => $resource,
            'supplier' => $supplier,
            'company' => $company

          ])
            ->setPaper('a4', 'portrait')
            ->set_option('enable_css', true)
            ->set_option('css_preload', true)
            ->output();

          return response()->streamDownload(
            fn() => print $pdfContent,
            'request_quotatation.pdf',
            [
              'Content-Type' => 'application/pdf',
            ],
            'inline'
          );
    }

}
