<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\request_dispatch;

use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\request_dispatch\RequestDispatchRepository;
use Illuminate\Http\Request;

/**
 * Class request_dispatchsTableController.
 */
class RequestDispatchsTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var RequestDispatchRepository
     */
    protected $request_dispatch;

    /**
     * contructor to initialize repository object
     * @param RequestDispatchRepository $request_dispatch ;
     */
    public function __construct(RequestDispatchRepository $request_dispatch)
    {
        $this->request_dispatch = $request_dispatch;
    }

    /**
     * This method return the data of the model
     * @param Managerequest_dispatchRequest $request
     *
     * @return mixed
     */
    public function __invoke(Request $request)
    {
        //
        $core = $this->request_dispatch->getForDataTable()->get();
        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('tid', function ($request_dispatch) {
                 return gen4tid('RFD-',$request_dispatch->tid);
            })
            ->addColumn('description', function ($request_dispatch) {
                 return $request_dispatch->description;
            })
            ->addColumn('item_type', function ($request_dispatch) {
                return $request_dispatch->item_type;
            })
            ->addColumn('status', function ($request_dispatch) {
                $badge_type = $request_dispatch->status == 'approved'? 'badge-primary' : 'badge-warning';
                return '<span data-id="'. $request_dispatch->id .'" class="badge '. $badge_type .'">'. ucfirst($request_dispatch->status) .'</span>';
                // return ucfirst($request_dispatch->status);
            })
            ->addColumn('date', function ($request_dispatch) {
                return Carbon::parse($request_dispatch->date)->toDateString();
            })
            ->addColumn('dnote_status', function ($request_dispatch) {
                // dd($request_dispatch->delivery);
                if (!$request_dispatch->delivery) return;
                return '<a href="'. route('biller.delivery_notes.show', $request_dispatch->delivery) .'">'. gen4tid('DN-',$request_dispatch->delivery->tid) .'</a>';
            })
            ->addColumn('actions', function ($request_dispatch) {
                $d_type = "data";
                $view = '<a href="' . route('biller.request_dispatchs.show', $request_dispatch->id) . '" class="btn btn-primary round" data-toggle="tooltip" data-placement="top" title="View"><i  class="fa fa-eye"></i></a>';
                if($request_dispatch->status == 'approved') return $view;

                return $request_dispatch->action_buttons;
            })
            ->make(true);
    }
}
