<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\request_dispatch;

use App\Models\request_dispatch\RequestDispatch;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\request_dispatch\CreateResponse;
use App\Http\Responses\Focus\request_dispatch\EditResponse;
use App\Repositories\Focus\request_dispatch\RequestDispatchRepository;
use App\Models\hrm\Hrm;



/**
 * request_dispatchsController
 */
class RequestDispatchsController extends Controller
{
    /**
     * variable to store the repository object
     * @var RequestDispatchRepository
     */
    protected $repository;

    /**
     * contructor to initialize repository object
     * @param RequestDispatchRepository $repository ;
     */
    public function __construct(RequestDispatchRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     *
     * @param App\Http\Requests\Focus\request_dispatch\Request $request
     * @return \App\Http\Responses\ViewResponse
     */
    public function index(Request $request)
    {
        return new ViewResponse('focus.request_dispatchs.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param Createrequest_dispatchRequestNamespace $request
     * @return \App\Http\Responses\Focus\request_dispatch\CreateResponse
     */
    public function create(Request $request)
    {
        return new CreateResponse('focus.request_dispatchs.create');
    }
    public function approved_request_dispatch(Request $request)
    {
        return new ViewResponse('focus.request_dispatchs.approved_dispatch');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param RequestNamespace $request
     * @return \App\Http\Responses\RedirectResponse
     */
    public function store(Request $request)
    {
        // dd($request->all());
        //Input received from the request
        $data = $request->only([
            'customer_id','date','tid','description','item_type'
        ]);
        $data['ins'] = auth()->user()->ins;
        $data['user_id'] = auth()->user()->id;

        $data_items = $request->only([
            'name','jobcard_id','item_id','box_bundle','no_of_bundle','datetime',
            'total_qty','balance_instock','type'
        ]);
        $data_items = modify_array($data_items);
        try {
            //Create the model using repository create method
            $this->repository->create(compact('data','data_items'));
        } catch (\Throwable $th) {dd($th);
            return errorHandler('Error Creating request_dispatchs', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.request_dispatchs.index'), ['flash_success' => 'RFD Created Successfully']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param App\Models\request_dispatch\request_dispatch $request_dispatch
     * @param Editrequest_dispatchRequestNamespace $request
     * @return \App\Http\Responses\Focus\request_dispatch\EditResponse
     */
    public function edit(RequestDispatch $request_dispatch, Request $request)
    {
        return new EditResponse($request_dispatch);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param Updaterequest_dispatchRequestNamespace $request
     * @param App\Models\request_dispatch\request_dispatch $request_dispatch
     * @return \App\Http\Responses\RedirectResponse
     */
    public function update(Request $request, RequestDispatch $request_dispatch)
    {
        //Input received from the request
        // dd($request->all());
        $data = $request->only(['customer_id','date','tid','description','item_type']);
        $data_items = $request->only([
            'name','jobcard_id','item_id','box_bundle','no_of_bundle','datetime',
            'total_qty','balance_instock','type','id'
        ]);
        $data_items = modify_array($data_items);
        try {
            //Update the model using repository update method
            $this->repository->update($request_dispatch, compact('data','data_items'));
        } catch (\Throwable $th) {
            return errorHandler('Error Updating request_dispatchs', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.request_dispatchs.index'), ['flash_success' => 'RFD Updated Successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param Deleterequest_dispatchRequestNamespace $request
     * @param App\Models\request_dispatch\request_dispatch $request_dispatch
     * @return \App\Http\Responses\RedirectResponse
     */
    public function destroy(RequestDispatch $request_dispatch, Request $request)
    {
        try {
            //Calling the delete method on repository
            $this->repository->delete($request_dispatch);
        } catch (\Throwable $th) {
            return errorHandler('Error Deleting request_dispatchs', $th);
        }
        //returning with successfull message
        return new RedirectResponse(route('biller.request_dispatchs.index'), ['flash_success' => 'RFD Deleted Successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param Deleterequest_dispatchRequestNamespace $request
     * @param App\Models\request_dispatch\request_dispatch $request_dispatch
     * @return \App\Http\Responses\RedirectResponse
     */
    public function show(RequestDispatch $request_dispatch, Request $request)
    {
        $employees = Hrm::all();
        //returning with successfull message
        return new ViewResponse('focus.request_dispatchs.view', compact('request_dispatch','employees'));
    }

    public function approve(Request $request, RequestDispatch $request_dispatch){
        // dd($request->all());
        $data = $request->only(['id','checked_by','status','approve_note']);
        $data['approved_by'] = auth()->user()->id;
        try {
            $this->repository->approve(compact('data'));
        } catch (\Throwable $th) {
            return errorHandler('Error Approving request_dispatchs', $th);
        }
        return back()->with('flash_success', 'RFD Successfully Approved');
    }

}
