<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\request_dispatch;

use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\request_dispatch\RequestDispatchRepository;
use Illuminate\Http\Request;

/**
 * Class request_dispatchsTableController.
 */
class ApprovedRequestDispatchsTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var RequestDispatchRepository
     */
    protected $request_dispatch;

    /**
     * contructor to initialize repository object
     * @param RequestDispatchRepository $request_dispatch ;
     */
    public function __construct(RequestDispatchRepository $request_dispatch)
    {
        $this->request_dispatch = $request_dispatch;
    }

    /**
     * This method return the data of the model
     * @param Managerequest_dispatchRequest $request
     *
     * @return mixed
     */
    public function __invoke()
    {
        //
        $core = $this->request_dispatch->getForDataTable();
        $core->where('status', 'approved')->doesntHave('delivery');
        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('tid', function ($request_dispatch) {
                 return gen4tid('RFD-',$request_dispatch->tid);
            })
            ->addColumn('description', function ($request_dispatch) {
                 return $request_dispatch->description;
            })
            ->addColumn('item_type', function ($request_dispatch) {
                return $request_dispatch->item_type;
            })
            ->addColumn('status', function ($request_dispatch) {
                $badge_type = $request_dispatch->status == 'approved'? 'badge-primary' : 'badge-warning';
                return '<span data-id="'. $request_dispatch->id .'" class="badge '. $badge_type .'">'. ucfirst($request_dispatch->status) .'</span>';
                // return ucfirst($request_dispatch->status);
            })
            ->addColumn('date', function ($request_dispatch) {
                return Carbon::parse($request_dispatch->date)->toDateString();
            })
            ->addColumn('dnote_status', function ($request_dispatch) {
                if ($request_dispatch->delivery) return '<a href="'. route('biller.delivery_notes.show', $request_dispatch->delivery) .'">'. $request_dispatch->delivery->tid .'</a>';
                return '<span data-id="'. $request_dispatch->id .'" invoice-url="'. route('biller.delivery_notes.raise_delivery_note', ['delivery_note_id' => $request_dispatch->id, '_token' => csrf_token()]) .'" data-status="'. $request_dispatch->status .'" class="badge badge-secondary dnote_status" style="cursor:pointer;">
                gen. delivery note <i class="fa fa-caret-down" aria-hidden="true"></i></span>';
            })
            ->addColumn('actions', function ($request_dispatch) {
                return $request_dispatch->action_buttons;
            })
            ->make(true);
    }
}
