<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\question;

use App\Models\question\Question;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\question\CreateResponse;
use App\Http\Responses\Focus\question\EditResponse;
use App\Repositories\Focus\question\QuestionRepository;



/**
 * questionsController
 */
class QuestionsController extends Controller
{
    /**
     * variable to store the repository object
     * @var questionRepository
     */
    protected $repository;

    /**
     * contructor to initialize repository object
     * @param questionRepository $repository ;
     */
    public function __construct(QuestionRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     *
     * @param App\Http\Requests\Focus\question\ManagequestionRequest $request
     * @return \App\Http\Responses\ViewResponse
     */
    public function index(Request $request)
    {
        return new ViewResponse('focus.questions.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param CreatequestionRequestNamespace $request
     * @return \App\Http\Responses\Focus\question\CreateResponse
     */
    public function create(Request $request)
    {
        return new CreateResponse('focus.questions.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StorequestionRequestNamespace $request
     * @return \App\Http\Responses\RedirectResponse
     */
    public function store(Request $request)
    {
        // dd($request->all());
        //Input received from the request
        $data = $request->only(['process_id']);
        $data_items = $request->only(['question']);
        $data['ins'] = auth()->user()->ins;
        $data['user_id'] = auth()->user()->id;

        $data_items = modify_array($data_items);
        try {
            //Create the model using repository create method
            $this->repository->create(compact('data', 'data_items'));
        } catch (\Throwable $th) {
            return errorHandler('Error Creating questions', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.questions.index'), ['flash_success' => 'Questions Created Successfully!!']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param App\Models\question\question $question
     * @param EditquestionRequestNamespace $request
     * @return \App\Http\Responses\Focus\question\EditResponse
     */
    public function edit(Question $question, Request $request)
    {
        return new EditResponse($question);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdatequestionRequestNamespace $request
     * @param App\Models\question\question $question
     * @return \App\Http\Responses\RedirectResponse
     */
    public function update(Request $request, Question $question)
    {
        //Input received from the request
        $data = $request->only(['process_id']);
        $data_items = $request->only(['id','question']);
        $data['ins'] = auth()->user()->ins;
        $data['user_id'] = auth()->user()->id;

        $data_items = modify_array($data_items);
        try {
            //Update the model using repository update method
            $this->repository->update($question, compact('data', 'data_items'));
        } catch (\Throwable $th) {
            return errorHandler('Error Updating questions', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.questions.index'), ['flash_success' => 'Questions Updated Successfully!!']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeletequestionRequestNamespace $request
     * @param App\Models\question\question $question
     * @return \App\Http\Responses\RedirectResponse
     */
    public function destroy(Question $question)
    {
        try {
            //Calling the delete method on repository
            $this->repository->delete($question);
        } catch (\Throwable $th) {
            return errorHandler('Error Deleting questions', $th);
        }
        //returning with successfull message
        return new RedirectResponse(route('biller.questions.index'), ['flash_success' => 'Questions Deleted Successfully!!']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeletequestionRequestNamespace $request
     * @param App\Models\question\question $question
     * @return \App\Http\Responses\RedirectResponse
     */
    public function show(Question $question, Request $request)
    {

        //returning with successfull message
        return new ViewResponse('focus.questions.view', compact('question'));
    }

}
