<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */

namespace App\Http\Controllers\Focus\purchase_request;

use App\Http\Controllers\Controller;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use App\Models\Access\User\User;
use App\Models\purchase_request\PurchaseRequest;
use App\Repositories\Focus\purchase_request\PurchaseRequestRepository;
use Illuminate\Http\Request;
use App\Models\purchase_request\PurchaseRequestItem;
use Yajra\DataTables\Facades\DataTables;
use App\Models\additional\Additional;

class PurchaseRequestsController extends Controller
{
    /**
     * variable to store the repository object
     * @var PurchaseRequestRepository
     */
    protected $repository;

    /**
     * contructor to initialize repository object
     * @param PurchaseRequestRepository $repository ;
     */
    public function __construct(PurchaseRequestRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return new ViewResponse('focus.purchase_requests.index');
    }

    /**
     * Show the form for creating a new resource.
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $tid = PurchaseRequest::where('ins', auth()->user()->ins)->max('tid');
        $users = User::all();

        return view('focus.purchase_requests.create', compact('users', 'tid'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return \App\Http\Responses\RedirectResponse
     */
    public function store(Request $request)
    {
       // dd($request->all());
        $data = $request->only(['tid', 'employee_id','date','priority','expect_date','job_card','note','stock_job','stock','item_type']);
        $data_items = $request->only('name', 'sku','uom','qty','item_id','type','supplier_id');

        $data['ins'] = auth()->user()->ins;
        $data['user_id'] = auth()->user()->id;
        $data_items = modify_array($data_items);
        //dd($data_items);
        try {
            $this->repository->create(compact('data', 'data_items'));
        } catch (\Throwable $th) {dd($th);
            return errorHandler('Error Creating Purchase Requisition', $th);
        }

        return new RedirectResponse(route('biller.purchase_requests.index'), ['flash_success' => 'Purchase Requisition Created Successfully']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  PurchaseRequest $purchase_request
     * @return \Illuminate\Http\Response
     */
    public function edit(PurchaseRequest $purchase_request)
    {
        $users = User::all();

        return view('focus.purchase_requests.edit', compact('purchase_request', 'users'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  PurchaseRequest $purchase_request
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, PurchaseRequest $purchase_request)
    {
        $data = $request->only(['tid', 'employee_id','date','priority','expect_date','job_card','note','stock_job','stock','item_type']);
        $data_items = $request->only('id','name', 'sku','uom','qty','item_id','type','supplier_id');

        $data['user_id'] = auth()->user()->id;
        $data['ins'] = auth()->user()->ins;

        $data_items = modify_array($data_items);
        try {
            $this->repository->update($purchase_request, compact('data', 'data_items'));
        } catch (\Throwable $th) {dd($th);
            return errorHandler('Error Updating Purchase Requisition', $th);
        }

        return new RedirectResponse(route('biller.purchase_requests.index'), ['flash_success' => 'Purchase Requisition Updated Successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  PurchaseRequest $purchase_request
     * @return \Illuminate\Http\Response
     */
    public function destroy(PurchaseRequest $purchase_request)
    {
        
        try {
            $this->repository->delete($purchase_request);
        } catch (\Throwable $th) {dd($th);
            return errorHandler('Error Deleting Purchase Requisition', $th);
        }

        return new RedirectResponse(route('biller.purchase_requests.index'), ['flash_success' => 'Purchase Requisition Deleted Successfully']);
    }


    /**
     * Display the specified resource.
     *
     * @param  PurchaseRequest $purchase_request
     * @return \Illuminate\Http\Response
     */
    public function show(PurchaseRequest $purchase_request)
    {
        return view('focus.purchase_requests.view', compact('purchase_request'));
    }

    public function approve(Request $request)
    {
        $purchase_request = PurchaseRequest::find($request->id);
        $purchase_request->status = $request->status;
        $purchase_request->status_note = $request->status_note;
        if($request->status == 'approved'){
            $purchase_request->purchase_status = 'pending';
            foreach($purchase_request->items as $item){
                $item->update([
                    'status_check'=> '1'
                ]);
            }
        }
        $purchase_request->update();
        return redirect()->back()->with('flash_status','Requisition Approved Successfully!!');
    }

    public function push_lpo(){
       // dd(request('job_card'));
        $purchase_requests = PurchaseRequest::where('status','approved')->get();
        $filters = PurchaseRequest::where('status','approved')->with('employee')->get(['id','job_card','priority','date','stock']);
        foreach ($filters as $filter) {
            $filter->employee = $filter->employee ?$filter->employee->first_name: '';
            //dd($filter->employee);
        }
        //($filters);
        $items = [];
        foreach ($purchase_requests as $purchase_request) {
            foreach ($purchase_request->items as $item) {
                $items = $item->where('status_check','0')->get();
            }
        }
        // dd($items);
        return view('focus.purchase_requests.create-push', compact('purchase_requests','items','filters'));
    }

    public function get_requisition_items(Request $request){
       // dd(request('job_card'));
        $q = PurchaseRequest::where('status','approved')->whereHas('items');
        $q->when(request('job_card'), fn($q) => $q->where('job_card', request('job_card')));
        $q->when(request('employee_id'), fn($q) => $q->where('employee_id', request('employee_id')));
        $q->when(request('priority'), fn($q) => $q->where('priority', request('priority')));
        $items = [];
        //dd($q->get());
        foreach ($q->get() as $purchase_request) {
            foreach ($purchase_request->items as $item) {
                //dd($item);
                $items = $item->where('status_check','0')->get();
                //dd($items);
            }
           // dd($items);
        }
        //dd($items);
        return response()->json($items);
    }

    public function store_push(Request $request){
       //dd($request->id);
       if ($request->id) {
            $req = PurchaseRequestItem::whereIn('id',$request->id)->update(['status_check'=> '1']);
            //return redirect()->back()->with('flash_success','Items Pushed to LPO');
       }
       return redirect()->back()->with('flash_success','Items Pushed to LPO');
    }

    public function purchase_search(Request $request)
    {
        if (!access()->allow('product_search')) return false;

        // fetch inventory products
        $products = Product::where('name', 'LIKE', '%' . request('keyword') . '%')
        ->with(['warehouse' => function ($q) {
            $q->select(['id', 'title']);
        }])->limit(6)->get()->unique('name');
        
        $product_items = array();
        foreach ($products as $row) {
            $product = array_intersect_key($row->toArray(), array_flip([
                'id', 'name', 'code', 'qty', 'image', 'purchase_price', 'sku', 'alert'
            ]));
            $product = $product + [
                'product_des' => $row->product_des,
                'uom' => $row->unit->code,
                'warehouse' => $row->warehouse->toArray()
            ];
            // purchase price set by inventory valuation (LIFO) method
            $product['purchase_price'] = $this->repository->eval_purchase_price($row->id, $row->qty, $row->purchase_price);
                
            $product_items[] =  $product;
        }

        return response()->json($product_items);
    }

    public function purchaseorder()
    {
        $products = PurchaseRequestItem::where(['status_check'=>'1','purchase_type'=>'purchase_order'])->get();

    }

    public function direct_purchase_order(Request $request)
    {
        $filters = PurchaseRequest::where('status','approved')->with('employee')->get(['id','job_card','priority','date','stock']);
        return view('focus.purchase_requests.push_direct_lpo', compact('filters'));
    }
    public function store_direct_lpo(Request $request)
    {
        //dd($request->all());
        if ($request->type == 'direct') {
            $req = PurchaseRequestItem::whereIn('id',$request->id)->update(['purchase_type'=> 'direct_purchase']);
            //dd($req);
            return response()->json('Items Pushed To Direct Purchase');
       }
        if ($request->type == 'lpo') {
            $req = PurchaseRequestItem::whereIn('id',$request->id)->update(['purchase_type'=> 'purchase_order']);
            //dd($req);
            return response()->json('Items Pushed To Purchase Order');
       }
       return response()->json('Items Pushed to LPO');
    }

    public function get_queued(Request $request)
    {
        $additionals = Additional::all();
        $pushed_items = PurchaseRequestItem::query()->where('status_check', '1')->whereColumn('qty_requested', '<', 'qty');
        if($request->preffered == 'preffered'){
            $pushed_items->when($request->item_type, fn($q) => $q->where('type', $request->item_type));
            $pushed_items->when($request->supplier_id, fn($q) => $q->where('supplier_id', $request->supplier_id));
        }else{
            $pushed_items->when($request->item_type, fn($q) => $q->where('type', $request->item_type));
        }
        $pushed_items->get();
       
        return Datatables::of($pushed_items)
            ->escapeColumns(['id'])
            ->addIndexColumn()    
            ->addColumn('check', function ($request) {
                return '<input type="checkbox" id="check" class="check" value="'.$request->id.'">'
                .'<input type="hidden" id="pid" name="requisition_item_id[]" class="form-control pid" value="'.$request->id.'" disabled>'
                .'<input type="hidden" id="product_id" name="product_id[]" class="form-control product_id" value="'.$request->item_id.'" disabled>';
            })
            ->addColumn('name', function ($request) {
                return $request->name
                .'<input type="hidden" id="product_name" name="name[]" class="form-control product_name" value="'.$request->name.'" disabled>'
                .'<input type="hidden" id="item_type" name="item_type[]" class="form-control item_type" value="'.$request->type.'" disabled>'
                .'<input type="hidden" id="unit_id" name="uom[]" class="form-control unit_id" value="'.$request->uom.'" disabled>';
            })
            ->addColumn('sku', function ($request) {
                return $request->sku;
            })
            ->addColumn('uom', function ($request) {
                return $request->unit ? $request->unit->code : @$request->product->unit->code;
            })
            ->addColumn('tid', function ($request) {
                return $request->purchase_request ? gen4tid('REQ-',$request->purchase_request->tid) : '';
            })
            ->addColumn('requisition_date', function ($request) {
                return $request->purchase_request ? dateFormat($request->purchase_request->date) : '';
            })
            ->addColumn('priority', function ($request) {
                return $request->purchase_request ? $request->purchase_request->priority : '';
            })
            ->addColumn('qty_purchased', function ($request) {
                $qty_remains = NumberFormat($request->qty - $request->qty_requested);
                return '<input type="text" id="qty_purchased" name="qty[]" class="form-control qty_purchased" value="'.$qty_remains.'" disabled>';
            })
            ->addColumn('price', function ($request) {
                $purchase_price = 0;
                if($request->requisition_item_type == 'paper'){
                    $purchase_price = $request->paper ? $request->paper->purchase_price : 0;
                }else if($request->requisition_item_type == 'other_items'){
                    $purchase_price = $request->product ? $request->product->purchase_price : 0;
                }
                return '<input type="text" id="price" name="purchase_price[]" class="form-control price" value="'.+$purchase_price.'" disabled>';
            })
            ->addColumn('item_type', function ($request) {
                return '<input type="text" id="item_type" class="form-control item_type" value="'.$request->type.'" disabled>';
            })
            ->addColumn('amount', function ($request) {
                return '<input type="text" id="amount" name="item_total[]" class="form-control amount" value="0" disabled>';
            })
            ->addColumn('taxable', function ($request) {
                return '<input type="text" id="taxable" name="itemtax[]" class="form-control taxable" value="0" disabled>';
            })
            ->addColumn('tax', function ($request) use($additionals) {
                return '<select class="form-control rowtax" name="tax_rate[]" id="rowtax-0" disabled><option value="" >Select Tax</option>' .
                    collect($additionals)->map(function ($category) {
                        return "<option value='$category->value'>$category->name</option>";
                    })->implode('') . '</select>';
            })
            ->addColumn('employee', function ($request) {
                $name = '';
                $purchase_request = $request->purchase_request;
                if($purchase_request){
                    $name = $purchase_request->employee ? $purchase_request->employee->first_name.' '.$purchase_request->employee->last_name : '';
                }
                return $name;
            })
            ->addColumn('qty', function ($request) {
                return NumberFormat($request->qty);
            })
            ->addColumn('qty_requested', function ($request) {
                return NumberFormat($request->qty_requested);
            })
            ->make(true);
    }
}
