<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */

namespace App\Http\Controllers\Focus\project;

use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\Request;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\project\TaskRepository;
use App\Http\Requests\Focus\project\ManageTaskRequest;

/**
 * Class TasksTableController.
 */
class TasksTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var TaskRepository
     */
    protected $task;

    /**
     * contructor to initialize repository object
     * @param TaskRepository $task ;
     */
    public function __construct(TaskRepository $task)
    {
        $this->task = $task;
    }

    /**
     * This method return the data of the model
     * @param ManageTaskRequest $request
     *
     * @return mixed
     */
    public function __invoke(Request $request)
    {
        
        $core = $this->task->getForDataTable();

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('start_date', function ($task) {
                return '<span  class="font-size-small">'. dateTimeFormat($task->start_date) .'</span>';
            })
            ->addColumn('end_date', function ($task) {
                return '<span  class="font-size-small">'. dateTimeFormat($task->end_date) .'</span>';
            })
            ->addColumn('name', function ($task) {
                return $task->name;
            })
            ->addColumn('jobcard_no', function ($task) {
                return $task->jobcard ? $task->jobcard->jobcard_no : '';
            })
            ->addColumn('total_board', function ($task) {
                return $task->jobcard ? NumberFormat($task->jobcard->total_board) : '';
            })
            ->addColumn('total_qty', function ($task) {
                return $task->jobcard ? NumberFormat($task->jobcard->total_qty) : '';
            })
            
            ->addColumn('qty_needed', function ($task) {
                return NumberFormat($task->qty_needed);
            })
            ->addColumn('actions', function ($task) {
                return '<button type="button" class="btn btn-purple round attach_jobcard" id="attach_jobcard" data-name="'.$task->id.'"  data-toggle="modal"
                data-target="#AddJobCardModal">
                Attach</i></button> '
               . $task->action_buttons;
            })
            ->make(true);
        
    }
}    
