<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */

namespace App\Http\Controllers\Focus\project;

use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\project\ProjectRepository;

/**
 * Class ProjectsTableController.
 */
class ProjectsTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var ProjectRepository
     */
    protected $repository;

    /**
     * contructor to initialize repository object
     * @param ProjectRepository $repository ;
     */
    public function __construct(ProjectRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * This method return the data of the model
     * @return mixed
     */
    public function __invoke()
    {
        $query = $this->repository->getForDataTable();

        return Datatables::of($query)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('customer', function($project) {
                $name = '';
                $customer = $project->customer_project;
                if ($customer) $name = "{$customer->company}";
                return $name;
            })
            ->addColumn('jobcard_no', function($project) {
                $name = '';
                $jobcard = $project->jobcard;
                if ($jobcard) $name = $jobcard->jobcard_no;
                return $name;
            })
            ->addColumn('tid', function($project) {
                return gen4tid('Prj-', $project->tid);
            })
            ->addColumn('start_date', function ($project) {
                return dateFormat($project->start_date);
            })
            ->addColumn('end_date', function ($project) {
                return dateFormat($project->end_date);
            })
            ->addColumn('qty_needed', function ($project) {
            return NumberFormat($project->qty_needed);
            })
            ->addColumn('delivery_date', function ($project) {
                return dateFormat($project->delivery_date);
            })
            ->addColumn('priority', function ($project) {
                return ucfirst($project->priority);
            })
            ->addColumn('actions', function ($project) {
                return $project->action_buttons;
            })
            ->make(true);
    }
}