<?php

namespace App\Http\Controllers\Focus\productconversion;

use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\productcategory\ProductcategoryRepository;
use App\Http\Requests\Focus\productcategory\ManageProductcategoryRequest;
use App\Repositories\Focus\productconversion\ProductConversionRepository;

/**
 * Class ProductcategoriesTableController.
 */
class ProductConversionTableController extends Controller
{
    protected $productconversion;

    public function __construct(ProductConversionRepository $productconversion)
    {
        $this->productconversion = $productconversion;
    }

    public function __invoke(ManageProductcategoryRequest $request)
    {
        //
        $core = $this->productconversion->getForDataTable();
        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('name', function ($productconversion) {
                // return '<a class="font-weight-bold" href="' . route('biller.products.index') . '?rel_type=' . $productconversion->c_type . '&rel_id=' . $productcategory->id . '">' . $productcategory->title . '</a>';
                return '<a class="font-weight-bold" href="">' . $productconversion->in_house_product . '</a>';

            })
            ->addColumn('unit_quantity', function ($productconversion) {
                return $productconversion->in_house_product_quantity;
            })
            ->addColumn('actions', function ($productconversion) {
                return $productconversion->action_buttons;
            })
            ->make(true);
    }
}
