<?php

namespace App\Http\Controllers\Focus\productcombination;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Responses\Focus\productcombination\CreateResponse;

use App\Models\product\Product;
use App\Models\product\ProductVariation;
use App\Models\productcategory\Productcategory;
use App\Models\warehouse\Warehouse;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\product\CreateModalResponse;
use App\Http\Responses\Focus\product\EditResponse;
use App\Repositories\Focus\product\ProductRepository;
use App\Http\Requests\Focus\product\ManageProductRequest;
use App\Http\Requests\Focus\product\CreateProductRequest;
use App\Http\Requests\Focus\product\EditProductRequest;
use App\Models\client_product\ClientProduct;
use App\Models\supplier_product\SupplierProduct;
use App\Models\product\ProductMeta;
use DB;
use Illuminate\Support\Arr;
use App\Models\productcombination\ProductCombination;
use App\Models\productvariable\Productvariable;


class ProductCombinationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return new CreateResponse('focus.productcombinations.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;
        $input['stock_type'] ="combined";

        $sku_exists = Product::where('sku', $input['sku'])->count();
        if (empty($input['sku']) || $sku_exists) {
            $input['sku'] = substr($input['name'], 0, 1) . substr($input['name'], -1) . rand(1, 10000);
        }


        try{
            DB::beginTransaction();
            $product = Product::create($input);

            if($product){
                $variation = ProductVariation::create([
                    'parent_id' => $product->id,
                    'purchase_price' => 0,
                    'minimum_selling_price' => 0,
                    'recommended_selling_price' => $input['recommended_selling_price'],
                    'alert' => $input['alert'],
                    'expiry' => $input['expiry'] ?? 0,
                    'warehouse_id' => $input['warehouse_id'],
                    'warehouse_row_id' => $input['warehouse_row_id'] ?? 1,
                    'warehouse_shelf_id' => $input['warehouse_shelf_id'] ?? 1,
                    'ins' => $input['ins'],
                ]);

                if($variation && $input['product_serial'] != null){
                    $product_serial = DB::table('product_meta')->insert([
                        'rel_type' => $product->id,
                        'rel_id' => $variation->id,
                        'value' => $input['product_serial'],
                        ]
                    );
                }
            }

            $product_combinations=[];
            $data_items = Arr::only($input, ['raw_material','raw_material_quantity']);
            $data_items = modify_array($data_items);
            foreach($data_items as $item){
                $product_combinations[] = array_replace($item,[
                    'product_id' => $product->id,
                    'ins' => auth()->user()->ins
                ]);
            }

            ProductCombination::insert($product_combinations);
            DB::commit();
            // $this->repository->create($input);
        }catch(\Throwable $th){
            return errorHandler('Error Creating Product', $th);
        }

        return new RedirectResponse(route('biller.products.index'), ['flash_success' => trans('alerts.backend.products.updated')]);

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getProcessing(){
        $ins = auth()->user()->ins;
        $products = Product::orderBy('name', 'ASC')->get();
        $product_categories = Productcategory::all();
        $productvariables = Productvariable::all();
        $warehouses = Warehouse::all();

        return view('focus.productcombinations.processed.create', compact('products', 'product_categories','productvariables','warehouses'));
    }
}
