<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\jobcard;

use App\Models\jobcard\JobCard;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\jobcard\CreateResponse;
use App\Http\Responses\Focus\jobcard\EditResponse;
use App\Repositories\Focus\jobcard\JobCardRepository;
use App\Models\bom\BoM;
use Yajra\DataTables\Facades\DataTables;
use App\Models\project\Project;
use App\Models\dispatch\DispatchItem;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Models\project\MilestoneJobCard;
use App\Models\jobcard\JobCardAttachment;
use App\Models\dispatch\DispatchCategory;
use App\Models\customer\Customer;

/**
 * jobcardsController
 */
class JobCardsController extends Controller
{
    /**
     * variable to store the repository object
     * @var jobcardRepository
     */
    protected $repository;

    /**
     * contructor to initialize repository object
     * @param jobcardRepository $repository ;
     */
    public function __construct(JobCardRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     *
     * @param App\Http\Requests\Focus\jobcard\ManagejobcardRequest $request
     * @return \App\Http\Responses\ViewResponse
     */
    public function index(Request $request)
    {
        $customers = Customer::all();
        return new ViewResponse('focus.jobcards.index', compact('customers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param CreatejobcardRequestNamespace $request
     * @return \App\Http\Responses\Focus\jobcard\CreateResponse
     */
    public function create(Request $request)
    {
        return new CreateResponse('focus.jobcards.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StorejobcardRequestNamespace $request
     * @return \App\Http\Responses\RedirectResponse
     */
    public function store(Request $request)
    {
        // dd($request->all());
        $flute = $request->input('flute', []);
        $flutes = implode(', ', $flute);
        //Input received from the request
        $data = $request->except(['_token', 'ins', 'tones','reel_size','gsm_value','kraft_liner','meters', 'liner_name','process_id','flute']);
        $data_items = $request->only([
            'tones','reel_size','gsm_value','kraft_liner','meters','liner_name'
        ]);
        $process_items = $request->only(['process_id']);
        $design_items = $request->only(['design_id']);
        $data['ins'] = auth()->user()->ins;
        $data['user_id'] = auth()->user()->id;
        $data['flute'] = $flutes;

        $data_items = modify_array($data_items);
        $process_items = modify_array($process_items);
        $design_items = modify_array($design_items);
        // dd($data);
        try {
            //Create the model using repository create method
            $this->repository->create(compact('data','data_items', 'process_items','design_items'));
        } catch (\Throwable $th) {dd($th);
            return errorHandler('Error Creating jobcards', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.jobcards.index'), ['flash_success' => 'JobCard Created Successfully!!']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param App\Models\jobcard\jobcard $jobcard
     * @param EditjobcardRequestNamespace $request
     * @return \App\Http\Responses\Focus\jobcard\EditResponse
     */
    public function edit(JobCard $jobcard, Request $request)
    {
        return new EditResponse($jobcard);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdatejobcardRequestNamespace $request
     * @param App\Models\jobcard\jobcard $jobcard
     * @return \App\Http\Responses\RedirectResponse
     */
    public function update(Request $request, JobCard $jobcard)
    {
        // dd($request->all());
        //Input received from the request
        $data = $request->except(['_token', 'ins', 'tones','reel_size','gsm_value','kraft_liner','meters','id','liner_name','process_id']);
        $data_items = $request->only([
            'tones','reel_size','gsm_value','kraft_liner','meters','liner_name','id'
        ]);
        $process_items = $request->only(['process_id']);
        $design_items = $request->only(['design_id']);
        $data['ins'] = auth()->user()->ins;
        $data['user_id'] = auth()->user()->id;

        $data_items = modify_array($data_items);
        $process_items = modify_array($process_items);
        $design_items = modify_array($design_items);
        try {
            //Update the model using repository update method
            $this->repository->update($jobcard, compact('data', 'data_items','process_items','design_items'));
        } catch (\Throwable $th) {dd($th);
            return errorHandler('Error Updating jobcards', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.jobcards.index'), ['flash_success' => 'JobCard Updated Successfully!!']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeletejobcardRequestNamespace $request
     * @param App\Models\jobcard\jobcard $jobcard
     * @return \App\Http\Responses\RedirectResponse
     */
    public function destroy(JobCard $jobcard, Request $request)
    {
        try {
            //Calling the delete method on repository
            $this->repository->delete($jobcard);
        } catch (\Throwable $th) {
            return errorHandler('Error Deleting jobcards', $th);
        }
        //returning with successfull message
        return new RedirectResponse(route('biller.jobcards.index'), ['flash_success' => 'JobCard Deleted Successfully!!']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeletejobcardRequestNamespace $request
     * @param App\Models\jobcard\jobcard $jobcard
     * @return \App\Http\Responses\RedirectResponse
     */
    public function show(JobCard $jobcard, Request $request)
    {
        $boms = BoM::all(['id','title']);
        $dispatch_category = DispatchCategory::all();
        //returning with successfull message
        return new ViewResponse('focus.jobcards.view', compact('jobcard', 'boms', 'dispatch_category'));
    }

    //Attach BoM
    public function attach_bom(Request $request)
    {
        $jobcard = JobCard::find($request->id);
        $jobcard->bom_id = $request->bom_id;
        $jobcard->update();
        return redirect()->back()->with('flash_success','Bom Attached Successfully!!');
    }
    public function approve(Request $request)
    {
        $jobcard = JobCard::find($request->id);
        if($request->type == 'job_status'){
            $jobcard->job_status = $request->job_status;
            $jobcard->update();
            return redirect()->back()->with('flash_success','JobCard Status Changed Successfully!!');
        }
        $jobcard->status = $request->status;
        $jobcard->approve_note = $request->approve_note;
        if($request->status == 'approved'){
            $jobcard->job_status = 'pending';
        }
        $jobcard->approved_by = auth()->user()->id;
        $jobcard->update();
        return redirect()->back()->with('flash_success','JobCard Approved Successfully!!');
    }

    public function attach_design(Request $request){
        // dd($request->all());
        $input['box_design'] = $request->only(['design','id']);
        // dd($input);
        foreach ($input as $key => $val) {
            // dd($val);
            if ($key == 'box_design') {
                if (isset($val['design'])) $request->validate(['design' => 'required|mimes:jpeg,jpg,png,pdf']);
            }
        }
        // dd($input);
        try {
            $this->repository->create_design($input);
        } catch (\Throwable $th) {
            if ($th instanceof ValidationException) throw $th;
            return errorHandler('Error Creating Job Design', $th);
        }

        return new RedirectResponse(route('biller.jobcards.index'), ['flash_success' => 'JobCard Design Created Successfully!!']);
    }
    public function attach_image(Request $request){
        // dd($request->all());
        $input['box_attachment'] = $request->only(['attachment','jobcard_id','description']);
        // dd($input);
        foreach ($input as $key => $val) {
            // dd($val);
            if ($key == 'box_attachment') {
                if (isset($val['attachment'])) $request->validate(['attachment' => 'required|mimes:jpeg,jpg,png,pdf']);
            }
        }
        $input['box_attachment']['ins'] = auth()->user()->ins;
        $input['box_attachment']['user_id'] = auth()->user()->id;
        // dd($input);
        try {
            $this->repository->create_attachment($input);
        } catch (\Throwable $th) {
            if ($th instanceof ValidationException) throw $th;
            return errorHandler('Error Creating Job Attachment', $th);
        }

        return redirect()->back()->with('flash_success', 'JobCard Attachment Created Successfully!!');
    }

    public function get_jobcards(Request $request)
    {
        // dd($request->all());
        $project = Project::find($request->project_id);
        //$card = [];
        $jobcards = [];
        foreach($project->tasks as $task)
        {
            $jobcard = $task->jobcards;
            // dd($jobcard);
            foreach ($jobcard as $job) {
                
                if ($job) {
                   $jobcards[] = $job;
                }
            }
            // dd($jobcard->taskjobcards);
            // foreach($jobcard as $cad){
                
            // }
        }
        //dd($jobcards);
        return Datatables::of($jobcards)
        ->escapeColumns(['id'])
        ->addIndexColumn()
        ->addColumn('jobcard_date', function ($jobcard) {
           // dd($jobcard);
            return dateFormat($jobcard->jobcard_date);
        })
        ->addColumn('total_qty', function ($jobcard) {
            return NumberFormat($jobcard->total_qty);
        })
        ->addColumn('total_board', function ($jobcard) {
            return NumberFormat($jobcard->total_board);
        })
        ->addColumn('jobcard_no', function ($jobcard) {
            return $jobcard->jobcard_no;
        })
        ->addColumn('actions', function ($jobcard) {
            return '<button type="button" class="btn btn-purple round attach_image" id="attach_image" data-id="'.$jobcard->id.'"  data-toggle="modal"
            data-target="#AddAttachmentModal">
            Attach</i></button> '.
            '<a href="' . route('biller.jobcards.detach', $jobcard->id) . '" class="btn btn-danger round" data-toggle="tooltip" data-placement="top" title="Detach"><i  class="fa fa-close "></i></a>'.
            $jobcard->action_buttons;
        })
        ->make(true);
    }

    public function detach($id){
        $attachment = MilestoneJobCard::where('jobcard_id', $id)->delete();
        return redirect()->back()->with('flash_success','JobCard Detached Successfully!!');
    }
    public function detach_image($id){
        // dd($id);
        $attachment = JobCardAttachment::find($id)->delete();
        if($attachment == true){

            return redirect()->back()->with('flash_success','JobCard Detached Successfully!!');
        }
        return redirect()->back()->with('flash_error','JobCard Detached Failed!!');
    }
    public function get_attachment(Request $request)
    {
        // dd($request->all());
        $project = Project::find($request->project_id);
        //$card = [];
        $job_attachments = [];
        foreach($project->tasks as $task)
        {
            $jobcard = $task->jobcards;
            // dd($jobcard);
            foreach ($jobcard as $job) {
                
                if ($job) {
                   $attachments = $job->attachments;
                   foreach ($attachments as $attachment) {
                    //    dd($attachment->design);
                       $job_attachments[] = $attachment->design;
                    // foreach($attachment->design as $design){
                    // }
                   }
                }
            }
            
        }
        // dd($job_attachments);
        return Datatables::of($job_attachments)
        ->escapeColumns(['id'])
        ->addIndexColumn()
        ->addColumn('jobcard_no', function ($jobcard) {
            $jobcard_no = '';
            if($jobcard->attachment){
                foreach($jobcard->attachment as $attach){
                    $jobcard_no = $attach->jobcard_no;
                }
            }
            return $jobcard_no;
        })
        ->addColumn('description', function ($jobcard) {
            return $jobcard->description;
        })
        ->addColumn('attachment', function ($jobcard) {
            // dd(asset('storage/img/jobcard/'.$jobcard->design));
            return  '<img class="zoom"
            src="' . asset('storage/img/designs/'.$jobcard->design) . '"
            alt="Image">';
        })
        ->addColumn('actions', function ($jobcard) {
            $id = '';
            if($jobcard->attach){
                foreach($jobcard->attach as $attach){
                    $id = $attach->id;
                }
            }
                // dd($id);
            return 
            '<a href="' . route('biller.jobcards.detach_image', $id) . '" class="btn btn-danger round" data-toggle="tooltip" data-placement="top" title="Detach"><i  class="fa fa-close "></i></a>';
        })
        ->make(true);
    }
    public function get_process(Request $request)
    {
        // dd($request->all());
        $project = Project::find($request->project_id);
        //$card = [];
        $jobprocesses = [];
        foreach($project->tasks as $task)
        {
            $jobcard = $task->jobcards;
            // dd($jobcard);
            foreach ($jobcard as $job) {
                
                if ($job) {
                   $processes = $job->processes;
                   foreach ($processes as $process) {
                        $jobprocesses[] = $process;
                   }
                }
            }
            
        }
        //dd($jobcards);
        return Datatables::of($jobprocesses)
        ->escapeColumns(['id'])
        ->addIndexColumn()
        ->addColumn('process_id', function ($process) {
            return $process->process_item ? $process->process_item->process_name : '';
        })
        ->addColumn('jobcard_id', function ($process) {
            return $process->jobcard ? $process->jobcard->jobcard_no : '';
        })
        ->addColumn('operator_id', function ($process) {
            return $process->hrm ? $process->hrm->first_name.' '.$process->hrm->last_name : '';
        })
        ->addColumn('date', function ($process) {
            return $process->date ? dateFormat($process->date) : '';
        })
        ->addColumn('start_time', function ($process) {
            return $process->start_time ? dateTimeFormat($process->start_time) : '';
        })
        ->addColumn('end_time', function ($process) {
            return $process->end_time ? dateTimeFormat($process->end_time) : '';
        })
        ->addColumn('record_qty', function ($process) {
            return $process->record_qty ? NumberFormat($process->record_qty) : '';
        })
        ->addColumn('board_rej', function ($process) {
            return $process->board_rej ? NumberFormat($process->board_rej) : '';
        })
        ->addColumn('qty_produced', function ($process) {
            return $process->qty_produced ? NumberFormat($process->qty_produced) : '';
        })
        ->addColumn('print_rej', function ($process) {
            return $process->print_rej ? NumberFormat($process->print_rej) : '';
        })
        ->addColumn('net_qty', function ($process) {
            return $process->net_qty ? NumberFormat($process->net_qty) : '';
        })
        ->addColumn('operator_sign', function ($process) {
            return $process->operator_sign ? $process->operator_sign : '';
        })
        
        ->make(true);
    }
    public function get_dispatch(Request $request)
    {
        // dd($request->all());
        $project = Project::find($request->project_id);
        $dispatch_category = DispatchCategory::all(['id', 'name']);
        //$card = [];
        $jobdispatch = [];
        $jobcard = [];
        $data = [];
        foreach($project->tasks as $task)
        {
            $jobcard = $task->jobcards;
            // dd($jobcard);
            foreach ($jobcard as $job) {
                
                if ($job) {
                   $dispatchs = $job->dispatch;
                //    foreach ($dispatchs as $dispatch) {
                //         // $jobdispatch[] = $dispatch;
                //         // foreach ($dispatch->dispatch_items as $item) {
                //         //     $jobdispatch[] = $item;
                //         // }
                        
                //    }
                // dd($dispatchs);
                
                
                foreach($dispatchs as $dispatch){
                    // dd($dispatch);
                    $datas ='
                                   <tr>
                                       <td>'.@$dispatch->jobcard->jobcard_no.'</td>
                                       <td>'.$dispatch->dispatch_name.'</td>';

                                       foreach($dispatch_category as $dispatchCategory){
                                        
                                        $datas .= '<td>'.@$dispatch->dispatch_items->where('dispatch_category_id', $dispatchCategory->id)->first()->dispatch_value ?? ''.'</td>';
                                       }
                                   '</tr>';
                                   $data[] = $datas;
                     }
                          
                   
                   
                }
            }
            
        }
        // dd($data);
        // return Datatables::of($jobdispatch)
        // ->escapeColumns(['id'])
        // ->addIndexColumn()
        // ->addColumn('process_id', function ($process) {
        //     return '';
        // })
        // ->make(true);
        // dd($data);
        return response()->json($data);
    }
    public function get_bom_items(Request $request)
    {
        // dd($request->all());
        $project = Project::find($request->project_id);
        //$card = [];
        $bom_items = [];
        foreach($project->tasks as $task)
        {
            $card = $task->jobcards;
            
            // dd($card->bom_items);
            foreach($card as $cad){
                // $bom_item = [];
                if($cad->bom){
                    foreach ($cad->bom->items as $item) {
                        $bom_items[] = $item;
                    }
                    
                }
                // $bom_items[] = $bom_item;
               // dd($cad->bom->bom_items);
            }
        }
        return DataTables::of($bom_items)
        ->escapeColumns(['id'])
        ->addIndexColumn()
        ->addColumn('jobcard', function ($bom_item) {
            return $bom_item->bom->jobcard ? $bom_item->bom->jobcard->jobcard_no : '';
        })
        ->addColumn('product', function ($bom_item) {
            return $bom_item->product;
        })
        ->addColumn('uom', function ($bom_item) {
            return $bom_item->uom;
        })
        ->addColumn('product_quantity', function ($bom_item) {
            return NumberFormat($bom_item->product_quantity);
        })
        ->addColumn('purchase_price', function ($bom_item) {
            return NumberFormat($bom_item->purchase_price);
        })
        ->make(true);
    }


    public function get_reel_size(Request $request)
    {
        $all_reel_sizes = DB::table('paper_reel_size')->get();
        $max_reel = DB::table('paper_reel_size')->orderBy('reel_to','desc')->first();
        $reel_size = 0;
        foreach($all_reel_sizes as $size)
        {
            if($request->size >= $size->reel_from && $request->size <= $size->reel_to){
                $reel_size += $size->reel_to;
            }
        }
        return response()->json($reel_size);
    }

    // Project Job Summary
    public function get_job_summary(Request $request)
    {
        $project = Project::find($request->project_id);
        //$card = [];
        $jobcards = [];
        foreach($project->tasks as $task)
        {
            $jobcard = $task->jobcards;
            // dd($jobcard);
            foreach ($jobcard as $job) {
                
                if ($job) {
                   $jobcards[] = $job;
                }
            }
            // dd($jobcard->taskjobcards);
            // foreach($jobcard as $cad){
                
            // }
        }
        //dd($jobcards);
        return Datatables::of($jobcards)
        ->escapeColumns(['id'])
        ->addIndexColumn()
        ->addColumn('jobcard_no', function ($jobcard) {
            return $jobcard->jobcard_no;
        })
        ->addColumn('task_qty_needed', function ($jobcard) {
            return NumberFormat($jobcard->task->qty_needed);
        })
        ->addColumn('total_per_jobcard', function ($jobcard) {
            return NumberFormat($jobcard->total_qty);
        })
        ->addColumn('project_qty_needed', function ($jobcard) {
            $project_qty = 0;
            $task = $jobcard->task;
            if($task){
                $project_qty = $task->project ? $task->project->qty_needed : '';
            }
            return NumberFormat($project_qty);
        })
        ->addColumn('total_dispatch', function ($jobcard) {
            $value = DispatchItem::whereHas('dispatch', function($q) use($jobcard){
                $q->where('jobcard_id', $jobcard->id)->whereHas('jobcard', function($q){
                    $q->where('job_status','dispatched');
                });
            })->whereHas('dispatch_category', function($q){
                $q->where('name','Total Qty');
            })->sum('dispatch_value');
            return $value;
        })
        ->addColumn('actions', function ($jobcard) {
            return $jobcard->action_buttons;
        })
        ->make(true);
    }

}
