<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\invoice_payment;

use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\invoice\InvoiceRepository;
use App\Http\Requests\Focus\invoice\ManageInvoiceRequest;
use App\Repositories\Focus\invoice_payment\InvoicePaymentRepository;

/**
 * Class InvoicesTableController.
 */
class InvoicePaymentsTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var InvoiceRepository
     */
    protected $repository;

    /**
     * contructor to initialize repository object
     * @param InvoiceRepository $repository ;
     */
    public function __construct(InvoicePaymentRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * This method return the data of the model
     * @param ManageInvoiceRequest $request
     *
     * @return mixed
     */
    public function __invoke(ManageInvoiceRequest $request)
    {
        $core = $this->repository->getForDataTable();
        $prefixes = prefixesArray(['invoice'], auth()->user()->ins);
        
        // aggregate
        $amount_total = $core->sum('amount');
        $aggregate = [
            'amount_total' => numberFormat($amount_total),
        ];

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()    
            ->editColumn('tid', function ($payment) {
                return gen4tid('PMT-', $payment->tid);
            })
            ->editColumn('ledger_id', function ($payment) {
                return @$payment->account->name;
            })        
            ->editColumn('date', function ($payment) {
                return dateFormat($payment->date);
            })
            ->editColumn('amount', function ($payment) {
                if ($payment->allocated_total > $payment->amount)
                    return numberFormat($payment->allocated_total);
                return numberFormat($payment->amount);
            })
            ->editColumn('doc_ref', function ($payment) {
                if ($payment->reference)
                return "{$payment->doc_reference} - {$payment->reference}";
            })
            ->addColumn('invoice_tid', function ($payment) use($prefixes) {
                $invoice_tids = [];
                foreach ($payment->items as $item) {
                    if ($item->invoice) $invoice_tids[] = gen4tid("{$prefixes[0]}-", $item->invoice->tid);
                }
                return implode(', ', $invoice_tids);
            })
            ->addColumn('aggregate', function ($payment) use($aggregate) {
                return $aggregate;
            })
            ->addColumn('actions', function ($payment) {
                // return $this->action_buttons($payment);
                return $payment->action_buttons;
            })
            ->make(true);
    }
}
