<?php

namespace App\Http\Controllers\Focus\invoice_payment;

use App\Http\Controllers\Controller;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use App\Models\account\Account;
use App\Models\currency\Currency;
use App\Models\customer\Customer;
use App\Models\invoice_payment\InvoicePayment;
use App\Repositories\Focus\invoice_payment\InvoicePaymentRepository;
use Illuminate\Http\Request;
use Illuminate\Validation\ValidationException;

class InvoicePaymentsController extends Controller
{
    /**
     * variable to store the repository object
     * @var InvoicePayment
     */
    protected $repository;

    /**
     * contructor to initialize repository object
     * @param InvoicePayment $repository ;
     */
    public function __construct(InvoicePaymentRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $customers = Customer::get(['id', 'company']);

        return new ViewResponse('focus.invoice_payments.index', compact('customers'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $accounts = Account::whereHas('account_type', fn($q) => $q->where('code', 'bank'))->get(['id', 'name']);
        $currencies = Currency::get();

        return new ViewResponse('focus.invoice_payments.create', compact('accounts', 'currencies'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        try {
            $this->repository->create($request->except('_token'));
        } catch (\Throwable $th) { 
            return errorHandler('Error Creating Invoice Payment', $th);
        }

        return new RedirectResponse(route('biller.invoice_payments.index'), ['flash_success' => 'Invoice Payment received successfully']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(InvoicePayment $invoice_payment)
    {
        return new ViewResponse('focus.invoice_payments.view', compact('invoice_payment'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(InvoicePayment $invoice_payment)
    {   
        $accounts = Account::whereHas('account_type', fn($q) => $q->where('code', 'bank'))->get(['id', 'name']);
        $currencies = Currency::get();

        return new ViewResponse('focus.invoice_payments.edit', compact('invoice_payment', 'accounts', 'currencies'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, InvoicePayment $invoice_payment)
    {
        try {
            $this->repository->update($invoice_payment, $request->except('_token'));
        } catch (\Throwable $th) {
            return errorHandler('Error Updating Invoice Payment', $th);
        }

        return new RedirectResponse(route('biller.invoice_payments.index'), ['flash_success' => 'Invoice Payment updated successfully']);
    }


    /**
     * Remove resource from storage
     */
    public function destroy(InvoicePayment $invoice_payment)
    {
        try {
            $this->repository->delete($invoice_payment);
        } catch (\Throwable $th) {
            return errorHandler('Error Deleting Payment', $th);
        }

        return new RedirectResponse(route('biller.invoice_payments.index'), ['flash_success' => 'Invoice Payment deleted successfully']);
    }
}
