<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\gsm;

use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\gsm\GSMRepository;
use Illuminate\Http\Request;

/**
 * Class gsmsTableController.
 */
class GSMsTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var gsmRepository
     */
    protected $gsm;

    /**
     * contructor to initialize repository object
     * @param gsmRepository $gsm ;
     */
    public function __construct(GSMRepository $gsm)
    {
        $this->gsm = $gsm;
    }

    /**
     * This method return the data of the model
     * @param Request $request
     *
     * @return mixed
     */
    public function __invoke(Request $request)
    {
        //
        $core = $this->gsm->getForDataTable();
        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('name', function ($gsm) {
                return $gsm->name;
            })
            ->addColumn('quality', function ($gsm) {
                return $gsm->quality;
            })
            ->addColumn('created_at', function ($gsm) {
                return dateFormat($gsm->created_at);
            })
            ->addColumn('actions', function ($gsm) {
                return $gsm->action_buttons;
            })
            ->make(true);
    }
}
