<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\gsm;

use App\Models\gsm\GSM;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\gsm\CreateResponse;
use App\Http\Responses\Focus\gsm\EditResponse;
use App\Repositories\Focus\gsm\GSMRepository;


/**
 * gsmsController
 */
class GSMsController extends Controller
{
    /**
     * variable to store the repository object
     * @var gsmRepository
     */
    protected $repository;

    /**
     * contructor to initialize repository object
     * @param gsmRepository $repository ;
     */
    public function __construct(GSMRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     *
     * @param App\Http\Requests\Focus\gsm\Request $request
     * @return \App\Http\Responses\ViewResponse
     */
    public function index(Request $request)
    {
        return new ViewResponse('focus.gsms.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param CreategsmRequestNamespace $request
     * @return \App\Http\Responses\Focus\gsm\CreateResponse
     */
    public function create(Request $request)
    {
        return new CreateResponse('focus.gsms.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param RequestNamespace $request
     * @return \App\Http\Responses\RedirectResponse
     */
    public function store(Request $request)
    {
        //Input received from the request
        $input = $request->except(['_token', 'ins']);
        $input['ins'] = auth()->user()->ins;
        try {
            //Create the model using repository create method
            $this->repository->create($input);
        } catch (\Throwable $th) {
            return errorHandler('Error Creating gsms', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.gsms.index'), ['flash_success' => 'GSM created Successfully!!']);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param App\Models\gsm\gsm $gsm
     * @param EditgsmRequestNamespace $request
     * @return \App\Http\Responses\Focus\gsm\EditResponse
     */
    public function edit(GSM $gsm, Request $request)
    {
        return new EditResponse($gsm);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdategsmRequestNamespace $request
     * @param App\Models\gsm\gsm $gsm
     * @return \App\Http\Responses\RedirectResponse
     */
    public function update(Request $request, GSM $gsm)
    {
        //Input received from the request
        $input = $request->except(['_token', 'ins']);
        try {
            //Update the model using repository update method
            $this->repository->update($gsm, $input);
        } catch (\Throwable $th) {
            return errorHandler('Error Updating gsms', $th);
        }
        //return with successfull message
        return new RedirectResponse(route('biller.gsms.index'), ['flash_success' => 'GSM Updated Successfully!!']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeletegsmRequestNamespace $request
     * @param App\Models\gsm\gsm $gsm
     * @return \App\Http\Responses\RedirectResponse
     */
    public function destroy(GSM $gsm, Request $request)
    {
        try {
            //Calling the delete method on repository
            $this->repository->delete($gsm);
        } catch (\Throwable $th) {
            return errorHandler('Error Deleting gsms', $th);
        }
        //returning with successfull message
        return new RedirectResponse(route('biller.gsms.index'), ['flash_success' => 'GSM Deleted Successfully!!']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeletegsmRequestNamespace $request
     * @param App\Models\gsm\gsm $gsm
     * @return \App\Http\Responses\RedirectResponse
     */
    public function show(GSM $gsm, Request $request)
    {

        //returning with successfull message
        return new ViewResponse('focus.gsms.view', compact('gsm'));
    }

}
