<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\delivery_note;

use Carbon\Carbon;
use App\Http\Controllers\Controller;
use Yajra\DataTables\Facades\DataTables;
use App\Models\delivery_note\DeliveryNote;


/**
 * Class DepartmentsTableController.
 */
class DeliveryNotesTableController extends Controller
{
    /**
     * variable to store the repository object
     * @var 
     */
    protected $delivery_note;

    

    /**
     * This method return the data of the model
     * @param Managedelivery_noteRequest $request
     *
     * @return mixed
     */
    public function __invoke()
    {
        //
        $core = DeliveryNote::get();
        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('tid', function ($delivery_note) {
                return gen4tid('DN-',$delivery_note->tid);
           })
           ->addColumn('description', function ($delivery_note) {
                return $delivery_note->description;
           })
           ->addColumn('item_type', function ($delivery_note) {
               return $delivery_note->item_type;
           })
           
           ->addColumn('date', function ($delivery_note) {
               return Carbon::parse($delivery_note->date)->toDateString();
           })
            ->addColumn('actions', function ($delivery_note) {
                return '<a href="' . route('biller.delivery_notes.show', $delivery_note->id) . '" class="btn btn-primary round" data-toggle="tooltip" data-placement="top" title="View"><i class="fa fa-eye"></i></a> ';
            })
            ->make(true);
    }
}
