<?php
/*
 * Rose Business Suite - Accounting, CRM and POS Software
 * Copyright (c) UltimateKode.com. All Rights Reserved
 * ***********************************************************************
 *
 *  Email: support@ultimatekode.com
 *  Website: https://www.ultimatekode.com
 *
 *  ************************************************************************
 *  * This software is furnished under a license and may be used and copied
 *  * only  in  accordance  with  the  terms  of such  license and with the
 *  * inclusion of the above copyright notice.
 *  * If you Purchased from Codecanyon, Please read the full License from
 *  * here- http://codecanyon.net/licenses/standard/
 * ***********************************************************************
 */
namespace App\Http\Controllers\Focus\delivery_note;

use App\Models\delivery_note\DeliveryNote;
use App\Models\request_dispatch\RequestDispatch;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use DB;
use App\Models\items\DeliveryNoteItem;


/**
 * DeliveryNotesController
 */
class DeliveryNotesController extends Controller
{
    /**
     * variable to store the repository object
     * @var DeliveryNoteRepository
     */
    protected $repository;

    

    /**
     * Display a listing of the resource.
     *
     * @param App\Http\Requests\Focus\DeliveryNote\ManageDeliveryNoteRequest $request
     * @return \App\Http\Responses\ViewResponse
     */
    public function index(Request $request)
    {
        return new ViewResponse('focus.delivery_notes.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @param CreateDeliveryNoteRequestNamespace $request
     * @return \App\Http\Responses\Focus\DeliveryNote\CreateResponse
     */
    public function create(Request $request)
    {
        return new ViewResponse('focus.delivery_notes.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StoreDeliveryNoteRequestNamespace $request
     * @return \App\Http\Responses\RedirectResponse
     */
    public function store(Request $request)
    {
        
        //return with successfull message
        return new RedirectResponse(route('biller.delivery_notes.index'), ['flash_success' => trans('alerts.backend.delivery_notes.created')]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param App\Models\DeliveryNote\DeliveryNote $DeliveryNote
     * @param EditDeliveryNoteRequestNamespace $request
     * @return \App\Http\Responses\Focus\DeliveryNote\EditResponse
     */
    public function edit(DeliveryNote $delivery_note, Request $request)
    {
        return new ViewResponse('focus.delivery_notes.edit');
    }

    /**
     * Update the specified resource in storage.
     *
     * @param UpdateDeliveryNoteRequestNamespace $request
     * @param App\Models\DeliveryNote\DeliveryNote $DeliveryNote
     * @return \App\Http\Responses\RedirectResponse
     */
    public function update(Request $request, DeliveryNote $delivery_note)
    {
        
        //return with successfull message
        return new RedirectResponse(route('biller.delivery_notes.index'), ['flash_success' => trans('alerts.backend.delivery_notes.updated')]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeleteDeliveryNoteRequestNamespace $request
     * @param App\Models\DeliveryNote\DeliveryNote $DeliveryNote
     * @return \App\Http\Responses\RedirectResponse
     */
    public function destroy(DeliveryNote $delivery_note, Request $request)
    {
        
        //returning with successfull message
        return new RedirectResponse(route('biller.delivery_notes.index'), ['flash_success' => trans('alerts.backend.delivery_notes.deleted')]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param DeleteDeliveryNoteRequestNamespace $request
     * @param App\Models\DeliveryNote\DeliveryNote $DeliveryNote
     * @return \App\Http\Responses\RedirectResponse
     */
    public function show($delivery_note, Request $request)
    {
        // dd($delivery_notes);
        $delivery_notes = DeliveryNote::find($delivery_note);
        //returning with successfull message
        return new ViewResponse('focus.delivery_notes.view', compact('delivery_notes'));
    }
    public function raise_delivery_note(Request $request) 
    {
        if ($request['_token'] != csrf_token()) abort(401, 'Unauthrozied');
        // dd($request->all());
        DB::beginTransaction();

        $request_dispatch = RequestDispatch::findOrFail($request['delivery_note_id']);
        // dd($request_dispatch->delivery);
        $request_dispatch_data = array_diff_key($request_dispatch->toArray(), array_flip([
            'id', 'tid', 'created_at', 'updated_at', 'status', 'status_note', 'status_mod_by', 'user_id', 'ins'
        ]));
        
        // invoice
        $dnote_data = array_replace($request_dispatch_data, [
            'tid' => DeliveryNote::max('tid')+1,
            'request_dispatch_id' => $request_dispatch->id,
            'ins' => auth()->user()->ins,
            'user_id' => auth()->user()->id,
        ]);
        $delivery_note = DeliveryNote::create($dnote_data);

        // delivery_note items
        $dnote_items_data = array_map(function($v) use($delivery_note) {
            $v = array_diff_key($v, array_flip([
                'id', 'request_dispatch_id', 'created_at', 'updated_at','checked_by',
                'approved_by', 'balance_instock','datetime','dnote_id'
            ]));
            return array_replace($v, [
                'delivery_note_id' => $delivery_note->id,
            ]);
        }, $request_dispatch->items->toArray());
        // dd($dnote_items_data);
         DeliveryNoteItem::insert($dnote_items_data);
         foreach ($request_dispatch->items as $i => $item) {
            // dd($item);
            $item->dnote_id = $delivery_note->id;
            $item->update();
            if($item->type == 'jobcard')
            {
                $jobcard = $item->jobcard;
                if($jobcard)
                {
                    $dispatch = $jobcard->dispatch->where('request_dispatch_id', $request_dispatch->id)->first();
                    $dispatch_item = $dispatch->dispatch_items->where('dispatch_category_id', '4')->first();
                    $dispatch_item->dispatch_value = \gen4tid('DN-', $delivery_note->tid);
                    $dispatch_item->update();
                    // dd($jobcard->dispatch->where('request_dispatch_id', $request_dispatch->id)->first(), $dispatch_item);
                }
            }
         }


        if ($delivery_note) {
            DB::commit();
            return back()->with('flash_status', 'DNOTE Created Successfully!!');
        }
    }

}
