<?php

namespace App\Http\Controllers\Focus\car_model;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Responses\ViewResponse;
use App\Models\car_model\CarModel;
use App\Repositories\Focus\car_model\CarModelRepository;
use Yajra\DataTables\Facades\DataTables;

class CarModelTableController extends Controller
{
    const MODEL = CarModel::class;

    protected $car_model;

    public function __construct(CarModelRepository $car_model)
    {
        $this->car_model = $car_model;
    }

    public function __invoke()
    {
        $core = $this->car_model->getForDataTable();

        // aggregate
        $car_models = CarModel::count();
        $aggregate = compact('car_models');

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('name', function ($car_model) {
                return $car_model->name;
            })
            ->addColumn('code', function ($car_model) {
                return $car_model->code;
            })
            ->addColumn('year', function ($car_model) {
                return  $car_model->year;
            })
            ->addColumn('created_at', function ($car_model) {
                return  $car_model->created_at->toDateString();
            })
            ->addColumn('actions', function ($car_model) {
                return $car_model->action_buttons;
            })
            ->addColumn('aggregate', function () use($aggregate) {
                return $aggregate;
            })
            ->make(true);
    }
}
