<?php

namespace App\Http\Controllers\Focus\car_model;

use App\Http\Controllers\Controller;
use App\Http\Requests\Focus\car_model\CreateCarModelRequest;
use App\Http\Requests\Focus\car_model\ManageCarModelRequest;
use App\Http\Requests\Focus\car_model\StoreCarModelRequest;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\car_model\CreateResponse;
use App\Repositories\Focus\car_model\CarModelRepository;
use App\Http\Responses\RedirectResponse;
use App\Models\car_model\CarModel;
use App\Http\Responses\Focus\car_model\EditResponse;

class CarModelController extends Controller
{
    protected $repository;
    public function __construct(CarModelRepository $repository){
        $this->repository = $repository;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(ManageCarModelRequest $request)
    {
        return new ViewResponse('focus.car_model.index');

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(CreateCarModelRequest $request)
    {
        return new CreateResponse('focus.car_model.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreCarModelRequest $request)
    {
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;
        $input['user_id'] = auth()->user()->id;


        // $code = Brand::where('code', $input['code'])->first();
        // $brand = Brand::where('name', $input['name'])->first();
        // if($code || $brand){
        //     return new RedirectResponse(route('biller.brand.index'), ['flash_error' => 'Brand already exists']);
        // }


        try {
            $this->repository->create($input);
        } catch (\Throwable $th) {
            // dd($th);
            return errorHandler('Error creating car model', $th);
        }
        return new RedirectResponse(route('biller.car-model.index'), ['flash_success' => 'Car model created successfully']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $car_model = CarModel::find($id);
        return new ViewResponse('focus.car_model.view', compact('car_model'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $car_model = CarModel::find($id);
        return new EditResponse($car_model);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(ManageCarModelRequest $request, $id)
    {
        $input = $request->all();
        $car_model = CarModel::find($id);

        try {
            $this->repository->update($car_model, $input);
        } catch (\Throwable $th) {
            // dd($th);
            return errorHandler('Error updating car model', $th);
        }
        return new RedirectResponse(route('biller.car-model.index'), ['flash_success' => 'Car model updated successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $car_model = CarModel::find($id);
        $car_model->delete();
        return new RedirectResponse(route('biller.car-model.index'), ['flash_success' => 'Car model deleted successfully']);
    }

    public function select(ManageCarModelRequest $request){
        $q = $request->keyword;
        $car_models = CarModel::where('name', 'LIKE', '%'.$q.'%')
            // ->where('active', 1)->orWhere('email', 'LIKE', '%'.$q.'')
            ->limit(6)->get(['id', 'name']);

        return response()->json($car_models);
    }
}
