<?php

namespace App\Http\Controllers\Focus\brands;

use App\Http\Controllers\Controller;
use App\Http\Requests\Focus\brand\CreateBrandRequest;
use App\Http\Requests\Focus\brand\ManageBrandRequest;
use App\Http\Requests\Focus\brand\StoreBrandRequest;
use App\Http\Requests\Focus\brand\UpdateBrandRequest;
use App\Repositories\Focus\brand\BrandRepository;
use Illuminate\Http\Request;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\Focus\brand\CreateResponse;
use App\Http\Responses\Focus\brand\EditResponse;
use App\Models\brand\Brand;

class BrandController extends Controller
{
    protected $repository;
    public function __construct(BrandRepository $repository){
        $this->repository = $repository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(ManageBrandRequest $request)
    {
        return new ViewResponse('focus.brands.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(CreateBrandRequest $request)
    {
        return new CreateResponse('focus.brands.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(StoreBrandRequest $request)
    {
        $input = $request->all();
        $input['ins'] = auth()->user()->ins;
        $input['user_id'] = auth()->user()->id;

        // $code = Brand::where('code', $input['code'])->first();
        // $brand = Brand::where('name', $input['name'])->first();
        // if($code || $brand){
        //     return new RedirectResponse(route('biller.brand.index'), ['flash_error' => 'Brand already exists']);
        // }


        try {
            $this->repository->create($input);
        } catch (\Throwable $th) {
            // dd($th);
            return errorHandler('Error creating brand', $th);
        }
        return new RedirectResponse(route('biller.brand.index'), ['flash_success' => 'Brand created successfully']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(ManageBrandRequest $request, $id)
    {
        $brand = Brand::where('id', $id)->first();
        return new ViewResponse('focus.brands.view', compact('brand'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $brand = Brand::where('id', $id)->first();
        return new EditResponse($brand);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(UpdateBrandRequest $request, $id)
    {
        $input = $request->all();
        // $input['ins'] = auth()->user()->ins;
        // $input['user_id'] = auth()->user()->id;


        // $code = Brand::where('code', $input['code'])->first();
        // $brand = Brand::where('name', $input['name'])->first();
        // if($code || $brand){
        //     return new RedirectResponse(route('biller.brand.index'), ['flash_error' => 'Brand already exists']);
        // }
        $brand = Brand::where('id', $id)->first();

        try {
            $this->repository->update($brand, $input);
        } catch (\Throwable $th) {
            // dd($th);
            return errorHandler('Error updating brand', $th);
        }
        return new RedirectResponse(route('biller.brand.index'), ['flash_success' => 'Brand updating successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $brand = Brand::where('id', $id)->first();
        $brand->delete();

        // try {
        //     $this->repository->delete($brand);
        // } catch (\Throwable $th) {
        //     dd($th);
        //     return errorHandler($th, 'Error deleting brand');
        // }

        return new RedirectResponse(route('biller.brand.index'), ['flash_success' => 'Brand deleted successfully']);
        // return json_encode(['status' => 'Success', 'message' => 'Brand deleted successfully.']);
    }
}
