<?php

namespace App\Http\Controllers\Focus\bom;

use App\Http\Controllers\Controller;
use App\Http\Requests\Focus\bom\ManageBoMRequest;
use App\Http\Requests\Focus\bom\StoreBoMRequest;
use App\Http\Responses\Focus\bom\EditResponse;
use Illuminate\Http\Request;
use App\Repositories\Focus\bom\BoMRepository;
use App\Http\Responses\Focus\bom\CreateResponse;
use App\Http\Responses\RedirectResponse;
use App\Http\Responses\ViewResponse;
use App\Models\bom\BoM;
use App\Models\bom\BoMItem;

class BoMController extends Controller
{
    protected $repository;
    public function __construct(BoMRepository $repository){
        $this->repository = $repository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return new ViewResponse('focus.bom.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return new CreateResponse('focus.bom.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->only([
            'title','description', 'bom_date','total_bom','jobcard_id'
        ]);
        $data_items = $request->only([
            'product','item_id','uom','product_quantity','purchase_price','product_type','num'
        ]);

        $data_items = modify_array($data_items);

        try {
            $this->repository->create(compact('data','data_items'));
        } catch (\Throwable $th) {
            dd($th);
            return errorHandler('Error creating Bill of Materials', $th);
        }

        return new RedirectResponse(route('biller.bom.index'), ['flash_success' => 'Bill of Materials created successfully.']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(BoM $bom)
    {
        return new ViewResponse('focus.bom.view', compact('bom'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(BoM $bom)
    {
        return new EditResponse($bom);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, BoM $bom)
    {
        $data = $request->only([
            'title','description', 'bom_date','total_bom','jobcard_id'
        ]);
        $data_items = $request->only([
            'product','item_id','uom','product_quantity','purchase_price','product_type','num','id'
        ]);
        $data_items = modify_array($data_items);
        try {
            $this->repository->update($bom, compact('data','data_items'));
        } catch (\Throwable $th) {
            dd($th);
            return errorHandler('Error updating bill of materials', $th);
        }
        //returning with successfull message
        return new RedirectResponse(route('biller.bom.index'), ['flash_success' => 'Bill of Materials updated successfully']);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(BoM $bom)
    {
        try {
            $this->repository->delete($bom);
        } catch (\Throwable $th) {
            return errorHandler('Error Deleting BoM', $th);
        }
        return new RedirectResponse(route('biller.bom.index'), ['flash_success' => 'Bill of Materials Deleted successfully']);
    }

    public function approve(Request $request)
    {
        $bom = BoM::find($request->id);
        $bom->status = $request->status;
        $bom->approve_note = $request->approve_note;
        $bom->approved_by = auth()->user()->id;
        $bom->update();
        return redirect()->back()->with('flash_success','bom Approved Successfully!!');
    }
}
