<?php

namespace App\Http\Controllers\Focus\assembly\material_issuing;

use App\Http\Controllers\Controller;
use App\Models\assembly\material_issuing\MaterialIssuing;
use App\Repositories\Focus\assembly\MaterialIssuingRepository;
use Yajra\DataTables\Facades\DataTables;

class MaterialIssuingTableController extends Controller
{
    const MODEL = MaterialIssuing::class;

    protected $material_issuing;

    public function __construct(MaterialIssuingRepository $material_issuing)
    {
        $this->material_issuing = $material_issuing;
    }

    public function __invoke()
    {
        $core = $this->material_issuing->getForDataTable();

        // aggregate
        $material_issuing = MaterialIssuing::count();
        $aggregate = compact('material_issuing');

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('operator', function ($material_issuing) {
                return '<a class="font-weight-bold" href="' . route('biller.assembly-station.show', [$material_issuing->id]) . '">' . $material_issuing->assembly_station->name . '</a>';
            })
            ->addColumn('items_issued', function ($material_issuing) {
                return  $material_issuing->material_issuing_items->count();
            })
            // ->addColumn('notes', function ($material_issuing) {
            //     return  $material_issuing->notes;
            // })
            ->addColumn('amount', function ($material_issuing) {
                return  $material_issuing->amount;
            })
            ->addColumn('issued_at', function ($material_issuing) {
                return  $material_issuing->issue_date;
            })
            ->addColumn('actions', function ($material_issuing) {
                return $material_issuing->action_buttons;
            })
            ->addColumn('aggregate', function () use($aggregate) {
                return $aggregate;
            })
            ->make(true);
    }
}
