<?php

namespace App\Http\Controllers\Focus\assembly\material_issuing;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\assembly\material_issuing\MaterialIssuing;
use App\Repositories\Focus\assembly\MaterialIssuingItemsRepository;
use Yajra\DataTables\Facades\DataTables;
use App\Models\assembly\material_issuing\MaterialIssuingItems;

class MaterialIssuingReportController extends Controller
{
    const MODEL = MaterialIssuingItems::class;

    protected $material_issuing;

    public function __construct(MaterialIssuingItemsRepository $material_issuing)
    {
        $this->material_issuing = $material_issuing;
    }

    public function __invoke()
    {
        $core = $this->material_issuing->getForDataTable();

        return Datatables::of($core)
        ->escapeColumns(['id'])
        ->addIndexColumn()
        ->addColumn('date', function ($row) {
            return $row->material_issuing->issue_date;
        })
        ->addColumn('station', function ($row) {
            return  $row->material_issuing->assembly_station->name;
        })
        ->addColumn('warehouse', function ($row) {
            return  $row->material_issuing->warehouse_station->title;
        })
        ->addColumn('product', function ($row) {
            return  $row->product->name;
        })
        ->addColumn('qty_available', function ($row) {
            return  $row->current_stock_quantity;
        })
        ->addColumn('qty_issued', function ($row) {
            return  $row->quantity_issued;
        })
        ->addColumn('qty_remaining', function ($row) {
            return  $row->current_stock_quantity -  $row->quantity_issued;
        })
        ->addColumn('issued_by', function ($row) {
            return  'To edit';
            // return  $row->issued_by->first_name.' '.$row->issued_by->last_name ;
        })
        ->addColumn('issued_to', function ($row) {
            return  'To edit';
        })
        ->make(true);
    }
}
