<?php

namespace App\Http\Controllers\Focus\assembly\assembly_station_operator;

use App\Http\Controllers\Controller;
use App\Repositories\Focus\assembly\AssemblyStationOperatorsRepository;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class AssemblyStationOperatorTableController extends Controller
{
    protected $assembly_station_operator;

    public function __construct(AssemblyStationOperatorsRepository $assembly_station_operator)
    {
        $this->assembly_station_operator = $assembly_station_operator;
    }

    public function __invoke()
    {
        $core = $this->assembly_station_operator->getForDataTable();

        // aggregate
        // $assembly_stations = AssemblyStation::count();
        // $aggregate = compact('assembly_stations');

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            // ->addColumn('name', function ($assembly_station_operator) {
            //     return '<a class="font-weight-bold" href="' . route('biller.assembly-station.show', [$assembly_station->id]) . '">' . $assembly_station->name . '</a>';
            // })
            ->addColumn('date', function ($assembly_station_operator) {
                // dd($assembly_station_operator->station->name);
                return  $assembly_station_operator->created_at->toDateString();
            })
            ->addColumn('station', function ($assembly_station_operator) {
                // dd($assembly_station_operator->station->name);
                return  $assembly_station_operator->station_name->name;
            })
            ->addColumn('operator', function ($assembly_station_operator) {
                return  $assembly_station_operator->operator_name->first_name.' '.$assembly_station_operator->operator_name->last_name;
            })
            ->addColumn('notes', function ($assembly_station_operator) {
                return  $assembly_station_operator->notes ? $assembly_station_operator->notes : "--";
            })
            ->addColumn('actions', function ($assembly_station_operator) {
                return $assembly_station_operator->action_buttons;
            })
            // ->addColumn('aggregate', function () use($aggregate) {
            //     return $aggregate;
            // })
            ->make(true);
    }
}
