<?php

namespace App\Http\Controllers\Focus\assembly\assembly_station_operator;

use App\Http\Controllers\Controller;
use App\Http\Requests\Focus\assembly\assembly_station_operator\CreateAssemblyStationOperatorRequest;
use App\Http\Requests\Focus\assembly\assembly_station_operator\ManageAssemblyStationOperatorRequest;
use Illuminate\Http\Request;
use App\Http\Responses\ViewResponse;
use App\Http\Responses\RedirectResponse;
use App\Models\assembly\assembly_station_operator\AssemblyStationOperator;
use App\Http\Responses\Focus\assembly\assembly_stations_operator\CreateResponse;
use App\Models\Access\User\User;
use App\Models\assembly\assembly_station\AssemblyStation;

class AssemblyStationOperatorController extends Controller
{
    protected $repository;

    public function __construct(AssemblyStationOperator $repository)
    {
        $this->repository = $repository;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(ManageAssemblyStationOperatorRequest $request)
    {
        $stations = AssemblyStation::all();
        $operators = User::all();
        return new ViewResponse('focus.assembly.assembly_station_operator.index', compact('stations', 'operators'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(CreateAssemblyStationOperatorRequest $request)
    {
        return new CreateResponse('focus.assembly.assembly_station_operator.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(CreateAssemblyStationOperatorRequest $request)
    {
        $input = $request->all();
        $input['user_id'] = auth()->user()->id;
        $input['ins'] = auth()->user()->ins;
        $input['status'] = 'active';

        try {
            $this->repository->create($input);
        } catch (\Throwable $th) {
            dd($th);
            return errorHandler('Error assigning an operator to the station station', $th);
        }

        return new RedirectResponse(route('biller.assembly-station-operator.index'), ['flash_success' => 'Station was assigned an operator successfully']);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(ManageAssemblyStationOperatorRequest $request, $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(CreateAssemblyStationOperatorRequest $request, $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(CreateAssemblyStationOperatorRequest $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(CreateAssemblyStationOperatorRequest $request, $id)
    {
        //
    }
}
