<?php

namespace App\Http\Controllers\Focus\assembly\assembly_station;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use App\Models\assembly\assembly_station\AssemblyStation;
use App\Repositories\Focus\assembly\AssemblyStationRepository;
use DB;

class AssemblyStationsTableController extends Controller
{
    protected $assembly_station;

    public function __construct(AssemblyStationRepository $assembly_station)
    {
        $this->assembly_station = $assembly_station;
    }

    public function __invoke()
    {
        $core = $this->assembly_station->getForDataTable();

        // aggregate
        $assembly_stations = AssemblyStation::count();
        $aggregate = compact('assembly_stations');

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('name', function ($assembly_station) {
                return '<a class="font-weight-bold" href="' . route('biller.assembly-station.show', [$assembly_station->id]) . '">' . $assembly_station->name . '</a>';
            })
            ->addColumn('description', function ($assembly_station) {
                return  $assembly_station->description;
            })
            ->addColumn('actions', function ($assembly_station) {
                return $assembly_station->action_buttons;
            })
            ->addColumn('aggregate', function () use($aggregate) {
                return $aggregate;
            })
            ->make(true);
    }
}
