<?php

namespace App\Http\Controllers\Focus\assembly\assembled_product;

use App\Http\Controllers\Controller;
use App\Models\assembly\assembled_product\AssembledProduct;
use App\Models\assembly\assembled_product\AssembledProductItem;
use App\Repositories\Focus\assembly\AssembledProductRepository;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class AssembledProductTableController extends Controller
{
    const MODEL = AssembledProduct::class;

    protected $assembled_product;

    public function __construct(AssembledProductRepository $assembled_product)
    {
        $this->assembled_product = $assembled_product;
    }

    public function __invoke()
    {
        $core = $this->assembled_product->getForDataTable();

        // $core = AssembledProductItem::all();

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('date', function ($row) {
                return $row->assemble_date;
                // return '<a class="font-weight-bold" href="' . route('biller.assembly-station.show', [$material_issuing->id]) . '">' . $material_issuing->assembly_station->name . '</a>';
            })
            ->addColumn('tid', function ($row) {
                return  $row->entry_no;
            })
            ->addColumn('actions', function ($row) {
                return $row->action_buttons;
            })
            ->make(true);
    }
}
