<?php

namespace App\Http\Controllers\Focus\assembly\assembled_product;

use App\Http\Controllers\Controller;
use App\Models\assembly\assembled_product\AssembledProductItem;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;
use App\Repositories\Focus\assembly\AssembledProductsReportRepository;

class AssembledProductReportController extends Controller
{
    const MODEL = AssembledProductItem::class;

    protected $assembled_product_item;

    public function __construct(AssembledProductsReportRepository $assembled_product_item)
    {
        $this->assembled_product_item = $assembled_product_item;
    }

    public function __invoke()
    {
        $core = $this->assembled_product_item->getForDataTable();

        // $core = AssembledProductItem::all();

        return Datatables::of($core)
            ->escapeColumns(['id'])
            ->addIndexColumn()
            ->addColumn('product', function ($row) {
                return  $row->product->name;
            })
            ->addColumn('initial_qty', function ($row) {
                return $row->current_stock_quantity;
            })
            ->addColumn('assembled_qty', function ($row) {
                return $row->assembled_quantity;
            })
            ->addColumn('final_qty', function ($row) {
                return  $row->current_stock_quantity + $row->assembled_quantity;
            })
            ->addColumn('uom', function ($row) {
                return $row->unit_of_measure->title;
            })
            ->addColumn('date', function ($row) {
                return $row->assembled_product->assemble_date;
            })
            ->addColumn('actions', function ($row) {
                return $row->action_buttons;
            })
            ->make(true);
    }
}
