<?php
namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;
use App\Models\assembly\material_issuing\MaterialIssuing;
use App\Models\assembly\material_issuing\MaterialIssuingItems;
use App\Models\jobcard\JobCard;
use App\Models\process\Process;
use App\Models\product\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
class ProductionConsumptionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function listJobCards()
    {
        $jobcards=JobCard::where('status','approved')->where('job_status','!=','complete')->get();
        return response()->json(['msg' => null, 'data' => $jobcards, 'success' => true], 200);
    }
    public function jobItemList()
    {
        $master=[];
        //item issued
        //load stages
        $jobcardid=1;
        $itesmByStages=Process::with(['materialIssuing'=>function($q) use($jobcardid){
            $q->where('job_card_id', $jobcardid);
        },'materialIssuing.material_issuing_items'])->whereHas('materialIssuing', function ($query) use ($jobcardid) {
            $query->where('job_card_id', $jobcardid);
        })->get();
        //List of items in stock
        $itemsInStock=Product::where('qty','>','0')->get();
        $master=array(
            'itesmByStages'=>$itesmByStages,
            'itemsInStock'=>$itemsInStock
        );
        return response()->json(['msg' => null, 'data' => $master, 'success' => true], 200);
    }
    public function issueProducts(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'job_card_id' => 'required',
            'station' => 'required',
            'product_id' => 'required',
            'qty' => 'required',
        ]);
    $is_valid=true;
        if ($validator->fails()) {
            $is_valid=false;
            $response=response()->json(['msg' => $validator->errors()->all(), 'data' => null, 'success' => false],422);
        }
        if($is_valid){
            // do logic to store data
            $input=$request->all();
            DB::beginTransaction();
            try {
                $data = MaterialIssuing::create($input);
                $input_array=[
                    'material_issuing_id'=>$data->id,
                    'product_id'=>$input['product_id'],
                    'qty'=>$input['qty'],
                    'uom'=>$input['uom'],
                    'user_id'=>Auth::id(),
                   
                ];
             MaterialIssuingItems::create($input_array);
             //Create logic to update bin card and stock
                $response=response()->json(['msg' => 'Record saved successfully', 'data' => null, 'success' => true],200);
            } catch (\Exception $e) {
                DB::rollBack();
                \Log::emergency("File:" . $e->getFile() . "Line:" . $e->getLine() . "Message:" . $e->getMessage());
                $response=response()->json(['msg' => $e->getMessage(), 'data' => null, 'success' => false],422);
            }
        }
        return $response;
     
    }
    
}
